/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.wrapper;

import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.wrapper.MethodCall;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceUtil {
    private static final String THREE_DOTS = "...";

    public static List<TraceElement> sortedByTime(@NotNull Collection<? extends TraceElement> values) {
        return values.stream().sorted(Comparator.comparing(TraceElement::getTime)).collect(Collectors.toList());
    }

    @Nullable
    public static Object extractKey(@NotNull TraceElement element) {
        Value value = element.getValue();
        if (!(value instanceof PrimitiveValue)) {
            return value;
        }
        if (value instanceof IntegerValue) {
            return ((IntegerValue)value).value();
        }
        if (value instanceof DoubleValue) {
            return ((DoubleValue)value).value();
        }
        if (value instanceof LongValue) {
            return ((LongValue)value).value();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).value();
        }
        if (value instanceof ByteValue) {
            return ((ByteValue)value).value();
        }
        if (value instanceof CharValue) {
            return Character.valueOf(((CharValue)value).value());
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((FloatValue)value).value());
        }
        throw new RuntimeException("unknown primitive value: " + value.type().name());
    }

    @NotNull
    public static String formatWithArguments(@NotNull MethodCall call2) {
        return call2.getName() + StreamEx.of(call2.getArguments()).map(x -> StringUtil.shortenTextWithEllipsis((String)x.getText().replaceAll("\\s", ""), (int)30, (int)5, (String)THREE_DOTS)).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
    }

    @NotNull
    public static String formatQualifierExpression(@NotNull String expression, int maxLength) {
        if ((expression = expression.replaceAll("\\s", "").replaceAll(",", ", ")).length() < maxLength) {
            return expression;
        }
        if (expression.isEmpty()) {
            return "qualifier";
        }
        return StringUtil.shortenTextWithEllipsis((String)expression, (int)(maxLength - 8), (int)5, (String)THREE_DOTS);
    }
}

