/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.ui.impl.CollectionTree;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleElementTree
extends CollectionTree {
    SingleElementTree(@Nullable Value value, @NotNull List<TraceElement> traceElements, @NotNull EvaluationContextImpl evaluationContext) {
        super(Collections.singletonList(value), traceElements, evaluationContext);
        this.addTreeListener(new XDebuggerTreeListener(){

            public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
                TreePath path = node.getPath();
                if (path.getPathCount() == 2) {
                    ApplicationManager.getApplication().invokeLater(() -> SingleElementTree.this.expandPath(path));
                    SingleElementTree.this.removeTreeListener(this);
                }
            }
        });
    }
}

