/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalTraceInterpreter
implements CallTraceInterpreter {
    private final CallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (value instanceof ArrayReference) {
            Value peeksResult = ((ArrayReference)value).getValue(0);
            TraceInfo peekInfo = this.myPeekResolver.resolve(call2, peeksResult);
            Map<Integer, TraceElement> before = peekInfo.getValuesOrderBefore();
            Value optionalTrace = ((ArrayReference)value).getValue(1);
            Value optionalValue = OptionalTraceInterpreter.getOptionalValue(optionalTrace);
            if (optionalValue == null) {
                return new ValuesOrderInfo(call2, before, Collections.emptyMap());
            }
            TraceElementImpl element = new TraceElementImpl(0x7FFFFFFE, optionalValue);
            return new ValuesOrderInfo(call2, before, Collections.singletonMap(element.getTime(), element));
        }
        throw new UnexpectedValueException("trace termination with optional result must be an array value");
    }

    @Nullable
    private static Value getOptionalValue(@NotNull Value optionalTrace) {
        if (!(optionalTrace instanceof ArrayReference)) {
            throw new UnexpectedValueTypeException("optional trace must be an array value");
        }
        ArrayReference trace = (ArrayReference)optionalTrace;
        if (!OptionalTraceInterpreter.optionalIsPresent(trace)) {
            return null;
        }
        Value value = trace.getValue(1);
        if (value instanceof ArrayReference) {
            return ((ArrayReference)value).getValue(0);
        }
        throw new UnexpectedValueTypeException("unexpected format for an optional value");
    }

    private static boolean optionalIsPresent(@NotNull ArrayReference optionalTrace) {
        Value isPresentValue;
        Value isPresentFlag = optionalTrace.getValue(0);
        if (isPresentFlag instanceof ArrayReference && (isPresentValue = ((ArrayReference)isPresentFlag).getValue(0)) instanceof BooleanValue) {
            return ((BooleanValue)isPresentValue).value();
        }
        throw new UnexpectedValueTypeException("unexpected format for optional isPresent value");
    }
}

