/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public class CollectIdentityTraceInterpreter
implements CallTraceInterpreter {
    private final SimplePeekCallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueTypeException("Array reference expected. But " + value.type().name() + " received");
        }
        ArrayReference array2 = (ArrayReference)value;
        TraceInfo resolved = this.myPeekResolver.resolve(call2, array2.getValue(0));
        Map<Integer, TraceElement> before = resolved.getValuesOrderBefore();
        if (before.isEmpty()) {
            return resolved;
        }
        int timeAfter = CollectIdentityTraceInterpreter.extractTime(array2) + 1;
        PrimitiveIterator.OfInt iterator = IntStreamEx.of(before.keySet()).sorted().iterator();
        HashMap<Integer, TraceElement> after = new HashMap<Integer, TraceElement>(before.size());
        while (iterator.hasNext()) {
            int timeBefore = iterator.next();
            TraceElement elementBefore = before.get(timeBefore);
            TraceElementImpl elementAfter = new TraceElementImpl(timeAfter, elementBefore.getValue());
            after.put(timeAfter, elementAfter);
            ++timeAfter;
        }
        return new ValuesOrderInfo(call2, before, after);
    }

    private static int extractTime(@NotNull ArrayReference value) {
        Value time;
        Value timeArray = value.getValue(1);
        if (timeArray instanceof ArrayReference && (time = ((ArrayReference)timeArray).getValue(0)) instanceof IntegerValue) {
            return ((IntegerValue)time).value();
        }
        throw new UnexpectedValueException("Could not find a maximum time value");
    }
}

