/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.trace.BidirectionalAwareState;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.impl.StateBase;
import com.intellij.debugger.streams.wrapper.StreamCall;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class IntermediateStateImpl
extends StateBase
implements BidirectionalAwareState {
    private final Map<TraceElement, List<TraceElement>> myToPrev;
    private final Map<TraceElement, List<TraceElement>> myToNext;
    private final StreamCall myNextCall;
    private final StreamCall myPrevCall;

    IntermediateStateImpl(@NotNull List<TraceElement> elements2, @NotNull StreamCall prevCall, @NotNull StreamCall nextCall, @NotNull Map<TraceElement, List<TraceElement>> toPrevMapping, @NotNull Map<TraceElement, List<TraceElement>> toNextMapping) {
        super(elements2);
        this.myToPrev = toPrevMapping;
        this.myToNext = toNextMapping;
        this.myPrevCall = prevCall;
        this.myNextCall = nextCall;
    }

    @Override
    @NotNull
    public StreamCall getPrevCall() {
        return this.myPrevCall;
    }

    @Override
    @NotNull
    public List<TraceElement> getPrevValues(@NotNull TraceElement value) {
        return this.myToPrev.getOrDefault(value, Collections.emptyList());
    }

    @Override
    @NotNull
    public StreamCall getNextCall() {
        return this.myNextCall;
    }

    @Override
    @NotNull
    public List<TraceElement> getNextValues(@NotNull TraceElement value) {
        return this.myToNext.getOrDefault(value, Collections.emptyList());
    }
}

