/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl;

import com.intellij.debugger.streams.trace.NextAwareState;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.impl.StateBase;
import com.intellij.debugger.streams.wrapper.StreamCall;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FirstStateImpl
extends StateBase
implements NextAwareState {
    private final StreamCall myNextCall;
    private final Map<TraceElement, List<TraceElement>> myToNext;

    FirstStateImpl(@NotNull List<TraceElement> elements2, @NotNull StreamCall nextCall, @NotNull Map<TraceElement, List<TraceElement>> toNextMapping) {
        super(elements2);
        this.myNextCall = nextCall;
        this.myToNext = toNextMapping;
    }

    @Override
    @NotNull
    public StreamCall getNextCall() {
        return this.myNextCall;
    }

    @Override
    @NotNull
    public List<TraceElement> getNextValues(@NotNull TraceElement value) {
        return this.myToNext.getOrDefault(value, Collections.emptyList());
    }
}

