/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class OptionalOrderResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        LinkedHashMap<TraceElement, List<TraceElement>> forward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        LinkedHashMap<TraceElement, List<TraceElement>> backward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        if (after.isEmpty()) {
            before.values().forEach(x -> forward.put((TraceElement)x, Collections.emptyList()));
        } else {
            assert (after.size() == 1);
            TraceElement optionalContent = after.values().iterator().next();
            ArrayList<TraceElement> backwardTrace = new ArrayList<TraceElement>();
            Object optionalKey = TraceUtil.extractKey(optionalContent);
            for (TraceElement beforeElement : before.values()) {
                if (Objects.equals(TraceUtil.extractKey(beforeElement), optionalKey)) {
                    backwardTrace.add(beforeElement);
                    forward.put(beforeElement, Collections.singletonList(optionalContent));
                    continue;
                }
                forward.put(beforeElement, Collections.emptyList());
            }
            backward.put(optionalContent, backwardTrace);
        }
        return ValuesOrderResolver.Result.of(forward, backward);
    }
}

