/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.MixInLegacyTypesClassLoader;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;

public class ClassLoaderStructureProvider {
    private final ClassLoaderRegistry classLoaderRegistry;

    public ClassLoaderStructureProvider(ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public ClassLoaderStructure getWorkerProcessClassLoaderStructure(Iterable<File> additionalClasspath, Class<?> ... classes) {
        MixInLegacyTypesClassLoader.Spec workerExtensionSpec = this.classLoaderRegistry.getGradleWorkerExtensionSpec();
        FilteringClassLoader.Spec gradleApiFilter = this.classLoaderRegistry.getGradleApiFilterSpec();
        VisitableURLClassLoader.Spec userSpec = this.getUserSpec("worker-loader", additionalClasspath, classes);
        return new HierarchicalClassLoaderStructure(workerExtensionSpec).withChild(gradleApiFilter).withChild(userSpec);
    }

    public ClassLoaderStructure getInProcessClassLoaderStructure(Iterable<File> additionalClasspath, Class<?> ... classes) {
        FilteringClassLoader.Spec gradleApiFilter = this.classLoaderRegistry.getGradleApiFilterSpec();
        VisitableURLClassLoader.Spec userSpec = this.getUserSpec("worker-loader", additionalClasspath, classes);
        return new HierarchicalClassLoaderStructure(gradleApiFilter).withChild(userSpec);
    }

    public VisitableURLClassLoader.Spec getUserSpec(String name, Iterable<File> additionalClasspath, Class<?> ... classes) {
        LinkedHashSet classpath = Sets.newLinkedHashSet();
        classpath.addAll(DefaultClassPath.of(additionalClasspath).getAsURLs());
        HashSet uniqueClassloaders = Sets.newHashSet();
        for (Class<?> clazz : classes) {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) continue;
            uniqueClassloaders.add(classLoader);
        }
        for (ClassLoader classLoader : uniqueClassloaders) {
            ClasspathUtil.collectClasspathUntil(classLoader, this.classLoaderRegistry.getGradleApiClassLoader(), classpath);
        }
        return new VisitableURLClassLoader.Spec(name, new ArrayList<URL>(classpath));
    }
}

