/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.gradle.api.Transformer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.serialize.Serializer;

public class InMemoryIndexedCache<K, V>
implements PersistentIndexedCache<K, V> {
    private final Map<Object, byte[]> entries = new ConcurrentHashMap<Object, byte[]>();
    private final ProducerGuard<K> producerGuard = ProducerGuard.serial();
    private final Serializer<V> valueSerializer;

    public InMemoryIndexedCache(Serializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public V get(K key) {
        byte[] serialised = this.entries.get(key);
        if (serialised == null) {
            return null;
        }
        try {
            ByteArrayInputStream instr = new ByteArrayInputStream(serialised);
            InputStreamBackedDecoder decoder = new InputStreamBackedDecoder(instr);
            return this.valueSerializer.read(decoder);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    @Override
    public V get(final K key, final Transformer<? extends V, ? super K> producer) {
        return this.producerGuard.guardByKey(key, new Supplier<V>(){

            @Override
            public V get() {
                if (!InMemoryIndexedCache.this.entries.containsKey(key)) {
                    InMemoryIndexedCache.this.put(key, producer.transform(key));
                }
                return InMemoryIndexedCache.this.get(key);
            }
        });
    }

    @Override
    public void put(K key, V value) {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        OutputStreamBackedEncoder encoder = new OutputStreamBackedEncoder(outstr);
        try {
            this.valueSerializer.write(encoder, value);
            encoder.flush();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        this.entries.put(key, outstr.toByteArray());
    }

    @Override
    public void remove(K key) {
        this.entries.remove(key);
    }

    public Set<K> keySet() {
        return this.entries.keySet();
    }
}

