/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.internal.impldep.com.google.common.base.Charsets;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.io.FileWriteMode;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.TypeValidationContext;
import org.gradle.plugin.devel.tasks.internal.PropertyValidationAccess;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;

public abstract class ValidateAction
implements WorkAction<Params> {
    @Override
    public void execute() {
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        final TreeMap taskValidationProblems = Maps.newTreeMap();
        final Params params = (Params)this.getParameters();
        params.getClasses().getAsFileTree().visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                ClassReader reader;
                if (!fileDetails.getPath().endsWith(".class")) {
                    return;
                }
                try {
                    reader = new ClassReader(Files.asByteSource((File)fileDetails.getFile()).read());
                }
                catch (IOException e) {
                    throw new org.gradle.api.UncheckedIOException(e);
                }
                ArrayList classNames = Lists.newArrayList();
                reader.accept((ClassVisitor)new TaskNameCollectorVisitor(classNames), 1);
                for (String className : classNames) {
                    Class<?> clazz;
                    try {
                        clazz = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException | IllegalAccessError | NoClassDefFoundError | VerifyError e) {
                        throw new GradleException("Could not load class: " + className, e);
                    }
                    ValidateAction.collectValidationProblems(clazz, taskValidationProblems, (Boolean)params.getEnableStricterValidation().get());
                }
            }
        });
        List<String> problemMessages = ValidateAction.toProblemMessages(taskValidationProblems);
        ValidateAction.storeResults(problemMessages, params.getOutputFile());
    }

    private static void collectValidationProblems(Class<?> topLevelBean, Map<String, Boolean> problems, boolean enableStricterValidation) {
        boolean mapErrorsToWarnings;
        boolean cacheable;
        if (Task.class.isAssignableFrom(topLevelBean)) {
            cacheable = enableStricterValidation || topLevelBean.isAnnotationPresent(CacheableTask.class);
            mapErrorsToWarnings = true;
        } else if (TransformAction.class.isAssignableFrom(topLevelBean)) {
            cacheable = topLevelBean.isAnnotationPresent(CacheableTransform.class);
            mapErrorsToWarnings = false;
        } else {
            cacheable = false;
            mapErrorsToWarnings = false;
        }
        DefaultTypeValidationContext validationContext = DefaultTypeValidationContext.withRootType(topLevelBean, cacheable);
        PropertyValidationAccess.collectValidationProblems(topLevelBean, validationContext);
        validationContext.getProblems().forEach((message, severity) -> problems.put((String)message, severity == TypeValidationContext.Severity.ERROR || !mapErrorsToWarnings));
    }

    private static void storeResults(List<String> problemMessages, RegularFileProperty outputFile) {
        if (outputFile.isPresent()) {
            File output = ((RegularFile)outputFile.get()).getAsFile();
            try {
                output.createNewFile();
                Files.asCharSink((File)output, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)Joiner.on((char)'\n').join(problemMessages));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    private static List<String> toProblemMessages(Map<String, Boolean> problems) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, Boolean> entry : problems.entrySet()) {
            String problem = entry.getKey();
            Boolean error = entry.getValue();
            builder.add((Object)String.format("%s: %s", Boolean.TRUE.equals(error) ? "Error" : "Warning", problem));
        }
        return builder.build();
    }

    private static class TaskNameCollectorVisitor
    extends ClassVisitor {
        private final Collection<String> classNames;

        public TaskNameCollectorVisitor(Collection<String> classNames) {
            super(458752);
            this.classNames = classNames;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 1) != 0) {
                this.classNames.add(name.replace('/', '.'));
            }
        }
    }

    public static interface Params
    extends WorkParameters {
        public ConfigurableFileCollection getClasses();

        public RegularFileProperty getOutputFile();

        public Property<Boolean> getEnableStricterValidation();
    }
}

