/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import groovy.lang.Closure;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.internal.BiAction;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.model.dsl.internal.inputs.PotentialInput;
import org.gradle.model.dsl.internal.inputs.PotentialInputs;
import org.gradle.model.dsl.internal.transform.InputReference;
import org.gradle.model.dsl.internal.transform.InputReferences;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.dsl.internal.transform.TransformedClosure;
import org.gradle.model.internal.core.DeferredModelAction;
import org.gradle.model.internal.core.InputUsingModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.ClosureBackedAction;

public class ClosureBackedRuleFactory {
    private static final ModelType<ManagedInstance> MANAGED_INSTANCE_TYPE = ModelType.of(ManagedInstance.class);
    private final Transformer<SourceLocation, TransformedClosure> ruleLocationExtractor;

    public ClosureBackedRuleFactory(RelativeFilePathResolver relativeFilePathResolver) {
        this.ruleLocationExtractor = new RelativePathSourceLocationTransformer(relativeFilePathResolver);
    }

    public static Object decorate(@Nullable ClosureBackedRuleFactory factory, Closure<?> closure) {
        return factory == null ? closure : factory.toAction(Object.class, closure);
    }

    public <T> DeferredModelAction toAction(final Class<T> subjectType, final Closure<?> closure) {
        final TransformedClosure transformedClosure = (TransformedClosure)closure;
        SourceLocation sourceLocation = this.ruleLocationExtractor.transform(transformedClosure);
        final ModelRuleDescriptor descriptor = sourceLocation.asDescriptor();
        return new DeferredModelAction(){

            @Override
            public ModelRuleDescriptor getDescriptor() {
                return descriptor;
            }

            @Override
            public void execute(MutableModelNode node, ModelActionRole role) {
                final boolean supportsNestedRules = node.canBeViewedAs(MANAGED_INSTANCE_TYPE);
                InputReferences inputs = transformedClosure.inputReferences();
                List<InputReference> inputReferences = supportsNestedRules ? inputs.getOwnReferences() : inputs.getAllReferences();
                final LinkedHashMap inputValues = Maps.newLinkedHashMap();
                ArrayList inputModelReferences = Lists.newArrayList();
                for (InputReference inputReference : inputReferences) {
                    String description = "@ line " + inputReference.getLineNumber();
                    String path = inputReference.getPath();
                    if (inputValues.containsKey(path)) continue;
                    inputValues.put(path, new PotentialInput(inputModelReferences.size()));
                    inputModelReferences.add(ModelReference.untyped(ModelPath.path(path), description));
                }
                node.applyToSelf(role, InputUsingModelAction.of(ModelReference.of(node.getPath(), subjectType), descriptor, inputModelReferences, new BiAction<T, List<ModelView<?>>>(){

                    @Override
                    public void execute(T t, List<ModelView<?>> modelViews) {
                        Closure cloned = closure.rehydrate(null, closure.getThisObject(), closure.getThisObject());
                        ((TransformedClosure)cloned).makeRule(new PotentialInputs(modelViews, inputValues), supportsNestedRules ? ClosureBackedRuleFactory.this : null);
                        ClosureBackedAction.execute(t, cloned);
                    }
                }));
            }
        };
    }

    private static class RelativePathSourceLocationTransformer
    implements Transformer<SourceLocation, TransformedClosure> {
        private final RelativeFilePathResolver relativeFilePathResolver;

        public RelativePathSourceLocationTransformer(RelativeFilePathResolver relativeFilePathResolver) {
            this.relativeFilePathResolver = relativeFilePathResolver;
        }

        @Override
        public SourceLocation transform(TransformedClosure closure) {
            SourceLocation sourceLocation = closure.sourceLocation();
            URI uri = sourceLocation.getUri();
            String scheme = uri.getScheme();
            String description = "file".equalsIgnoreCase(scheme) ? this.relativeFilePathResolver.resolveAsRelativePath(uri) : uri.toString();
            return new SourceLocation(uri, description, sourceLocation.getExpression(), sourceLocation.getLineNumber(), sourceLocation.getColumnNumber());
        }
    }
}

