/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.util.GFileUtils;
import org.gradle.util.GradleVersion;

class WelcomeMessageAction
implements Action<ExecutionListener> {
    private final Logger logger;
    private final BuildLayoutParameters buildLayoutParameters;
    private final GradleVersion gradleVersion;
    private final Function<String, InputStream> inputStreamProvider;
    private final Action<ExecutionListener> action;

    WelcomeMessageAction(BuildLayoutParameters buildLayoutParameters, Action<ExecutionListener> action) {
        this(Logging.getLogger(WelcomeMessageAction.class), buildLayoutParameters, GradleVersion.current(), new Function<String, InputStream>(){

            @Nullable
            public InputStream apply(@Nullable String input) {
                return this.getClass().getClassLoader().getResourceAsStream(input);
            }
        }, action);
    }

    @VisibleForTesting
    WelcomeMessageAction(Logger logger, BuildLayoutParameters buildLayoutParameters, GradleVersion gradleVersion, Function<String, InputStream> inputStreamProvider, Action<ExecutionListener> action) {
        this.logger = logger;
        this.buildLayoutParameters = buildLayoutParameters;
        this.gradleVersion = gradleVersion;
        this.inputStreamProvider = inputStreamProvider;
        this.action = action;
    }

    @Override
    public void execute(ExecutionListener executionListener) {
        File markerFile;
        if (this.isWelcomeMessageEnabled() && !(markerFile = this.getMarkerFile()).exists() && this.logger.isLifecycleEnabled()) {
            this.logger.lifecycle("");
            this.logger.lifecycle("Welcome to Gradle " + this.gradleVersion.getVersion() + "!");
            String featureList = this.readReleaseFeatures();
            if (StringUtils.isNotBlank((String)featureList)) {
                this.logger.lifecycle("");
                this.logger.lifecycle("Here are the highlights of this release:");
                this.logger.lifecycle(StringUtils.stripEnd((String)featureList, (String)" \n\r"));
            }
            if (!this.gradleVersion.isSnapshot()) {
                this.logger.lifecycle("");
                this.logger.lifecycle("For more details see https://docs.gradle.org/" + this.gradleVersion.getVersion() + "/release-notes.html");
            }
            this.logger.lifecycle("");
            this.writeMarkerFile(markerFile);
        }
        this.action.execute(executionListener);
    }

    private boolean isWelcomeMessageEnabled() {
        String messageEnabled = System.getProperty("org.gradle.internal.launcher.welcomeMessageEnabled");
        if (messageEnabled == null) {
            return true;
        }
        return Boolean.parseBoolean(messageEnabled);
    }

    private File getMarkerFile() {
        File gradleUserHomeDir = this.buildLayoutParameters.getGradleUserHomeDir();
        File notificationsDir = new File(gradleUserHomeDir, "notifications");
        File versionedNotificationsDir = new File(notificationsDir, this.gradleVersion.getVersion());
        return new File(versionedNotificationsDir, "release-features.rendered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readReleaseFeatures() {
        InputStream inputStream = (InputStream)this.inputStreamProvider.apply((Object)"release-features.txt");
        if (inputStream != null) {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)"UTF-8");
                String string = writer.toString();
                return string;
            }
            catch (IOException iOException) {
            }
            finally {
                IoActions.closeQuietly(inputStream);
            }
        }
        return null;
    }

    private void writeMarkerFile(File markerFile) {
        GFileUtils.mkdirs(markerFile.getParentFile());
        GFileUtils.touch(markerFile);
    }
}

