/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.gradle.api.file.RelativePath;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;

class InstrumentingClasspathFileTransformer
implements ClasspathFileTransformer {
    private static final Attributes.Name DIGEST_ATTRIBUTE = new Attributes.Name("SHA1-Digest");
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final CachedClasspathTransformer.Transform transform;
    private final HashCode configHash;

    public InstrumentingClasspathFileTransformer(ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, CachedClasspathTransformer.Transform transform) {
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.transform = transform;
        Hasher hasher = Hashing.defaultFunction().newHasher();
        transform.applyConfigurationTo(hasher);
        this.configHash = hasher.hash();
    }

    @Override
    public File transform(File source, CompleteFileSystemLocationSnapshot sourceSnapshot, File cacheDir) {
        String name = sourceSnapshot.getType() == FileType.Directory ? source.getName() + ".jar" : source.getName();
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putHash(this.configHash);
        hasher.putHash(sourceSnapshot.getHash());
        HashCode fileHash = hasher.hash();
        File transformed = new File(cacheDir, fileHash.toString() + '/' + name);
        if (!transformed.isFile()) {
            this.transform(source, transformed);
        }
        return transformed;
    }

    private void transform(File source, File dest) {
        this.classpathBuilder.jar(dest, builder -> this.classpathWalker.visit(source, entry -> {
            if (entry.getName().endsWith(".class")) {
                ClassReader reader = new ClassReader(entry.getContent());
                ClassWriter classWriter = new ClassWriter(1);
                Pair<RelativePath, ClassVisitor> chain = this.transform.apply(entry, (ClassVisitor)classWriter);
                reader.accept((ClassVisitor)chain.right, 0);
                byte[] bytes = classWriter.toByteArray();
                builder.put(((RelativePath)chain.left).getPathString(), bytes);
            } else if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                Manifest manifest = new Manifest(new ByteArrayInputStream(entry.getContent()));
                manifest.getMainAttributes().remove(Attributes.Name.SIGNATURE_VERSION);
                Iterator<Map.Entry<String, Attributes>> entries = manifest.getEntries().entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<String, Attributes> manifestEntry = entries.next();
                    Attributes attributes = manifestEntry.getValue();
                    attributes.remove(DIGEST_ATTRIBUTE);
                    if (!attributes.isEmpty()) continue;
                    entries.remove();
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                manifest.write(outputStream);
                builder.put(entry.getName(), outputStream.toByteArray());
            } else if (!entry.getName().startsWith("META-INF/") || !entry.getName().endsWith(".SF")) {
                builder.put(entry.getName(), entry.getContent());
            }
        }));
    }
}

