/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.List;
import java.util.SortedSet;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.execution.TaskSnapshotter;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.internal.fingerprint.FileCollectionSnapshotter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.CompositeFileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskSnapshotter
implements TaskSnapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskSnapshotter.class);
    private final FileCollectionSnapshotter fileCollectionSnapshotter;

    public DefaultTaskSnapshotter(FileCollectionSnapshotter fileCollectionSnapshotter) {
        this.fileCollectionSnapshotter = fileCollectionSnapshotter;
    }

    @Override
    public ImmutableSortedMap<String, FileSystemSnapshot> snapshotTaskFiles(TaskInternal task, SortedSet<? extends FilePropertySpec> fileProperties) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (FilePropertySpec filePropertySpec : fileProperties) {
            LOGGER.debug("Snapshotting property {} for {}", (Object)filePropertySpec, (Object)task);
            List<FileSystemSnapshot> result = this.fileCollectionSnapshotter.snapshot(filePropertySpec.getPropertyFiles());
            builder.put((Object)filePropertySpec.getPropertyName(), (Object)CompositeFileSystemSnapshot.of(result));
        }
        return builder.build();
    }
}

