/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.vfs.AdditiveCacheLocations;

public class SplitFileHasher
implements FileHasher {
    private final FileHasher globalHasher;
    private final FileHasher localHasher;
    private final AdditiveCacheLocations additiveCacheLocations;

    public SplitFileHasher(FileHasher globalHasher, FileHasher localHasher, AdditiveCacheLocations additiveCacheLocations) {
        this.globalHasher = globalHasher;
        this.localHasher = localHasher;
        this.additiveCacheLocations = additiveCacheLocations;
    }

    @Override
    public HashCode hash(File file) {
        if (this.additiveCacheLocations.isInsideAdditiveCache(file.getPath())) {
            return this.globalHasher.hash(file);
        }
        return this.localHasher.hash(file);
    }

    @Override
    public HashCode hash(File file, long length, long lastModified) {
        if (this.additiveCacheLocations.isInsideAdditiveCache(file.getPath())) {
            return this.globalHasher.hash(file, length, lastModified);
        }
        return this.localHasher.hash(file, length, lastModified);
    }
}

