/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.AmbiguousTransformException;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedResolvedVariant;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationNodeRegistry;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.component.AmbiguousVariantSelectionException;
import org.gradle.internal.component.NoMatchingVariantSelectionException;
import org.gradle.internal.component.VariantSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.DescriberSelector;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

class AttributeMatchingVariantSelector
implements VariantSelector {
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributesFactory attributesFactory;
    private final TransformationNodeRegistry transformationNodeRegistry;
    private final ImmutableAttributes requested;
    private final boolean ignoreWhenNoMatches;
    private final ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver;

    AttributeMatchingVariantSelector(ConsumerProvidedVariantFinder consumerProvidedVariantFinder, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory, TransformationNodeRegistry transformationNodeRegistry, AttributeContainerInternal requested, boolean ignoreWhenNoMatches, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver) {
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
        this.transformationNodeRegistry = transformationNodeRegistry;
        this.requested = requested.asImmutable();
        this.ignoreWhenNoMatches = ignoreWhenNoMatches;
        this.dependenciesResolver = dependenciesResolver;
    }

    public String toString() {
        return "Variant selector for " + this.requested;
    }

    @Override
    public ResolvedArtifactSet select(ResolvedVariantSet producer) {
        try {
            return this.doSelect(producer, AttributeMatchingExplanationBuilder.logging());
        }
        catch (VariantSelectionException t) {
            return new BrokenResolvedArtifactSet(t);
        }
        catch (Exception t) {
            return new BrokenResolvedArtifactSet(VariantSelectionException.selectionFailed(producer, t));
        }
    }

    private ResolvedArtifactSet doSelect(ResolvedVariantSet producer, AttributeMatchingExplanationBuilder explanationBuilder) {
        AttributeMatcher matcher = this.schema.withProducer(producer.getSchema());
        ImmutableAttributes componentRequested = this.attributesFactory.concat(this.requested, producer.getOverriddenAttributes());
        List<ResolvedVariant> matches = matcher.matches(producer.getVariants(), componentRequested, explanationBuilder);
        if (matches.size() == 1) {
            return matches.get(0).getArtifacts();
        }
        if (matches.size() > 1) {
            if (explanationBuilder instanceof TraceDiscardedVariants) {
                Set discarded = (Set)Cast.uncheckedCast(((TraceDiscardedVariants)explanationBuilder).discarded);
                AttributeDescriber describer = DescriberSelector.selectDescriber(componentRequested, this.schema);
                throw new AmbiguousVariantSelectionException(describer, producer.asDescribable().getDisplayName(), componentRequested, matches, matcher, discarded);
            }
            return this.doSelect(producer, new TraceDiscardedVariants());
        }
        List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates = new ArrayList<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>>();
        for (ResolvedVariant variant : producer.getVariants()) {
            ImmutableAttributes variantAttributes = variant.getAttributes().asImmutable();
            ConsumerVariantMatchResult matchResult = this.consumerProvidedVariantFinder.collectConsumerVariants(variantAttributes, componentRequested);
            for (ConsumerVariantMatchResult.ConsumerVariant consumerVariant : matchResult.getMatches()) {
                candidates.add(Pair.of(variant, consumerVariant));
            }
        }
        if (candidates.size() > 1) {
            candidates = this.tryDisambiguate(matcher, candidates, componentRequested, explanationBuilder);
        }
        if (candidates.size() == 1) {
            Pair result = (Pair)candidates.get(0);
            ResolvedArtifactSet artifacts = ((ResolvedVariant)result.getLeft()).getArtifacts();
            AttributeContainerInternal attributes = ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).attributes;
            Transformation transformation = ((ConsumerVariantMatchResult.ConsumerVariant)result.getRight()).transformation;
            return new ConsumerProvidedResolvedVariant(producer.getComponentId(), artifacts, attributes, transformation, this.dependenciesResolver, this.transformationNodeRegistry);
        }
        if (!candidates.isEmpty()) {
            throw new AmbiguousTransformException(producer.asDescribable().getDisplayName(), componentRequested, candidates);
        }
        if (this.ignoreWhenNoMatches) {
            return ResolvedArtifactSet.EMPTY;
        }
        throw new NoMatchingVariantSelectionException(producer.asDescribable().getDisplayName(), componentRequested, producer.getVariants(), matcher, DescriberSelector.selectDescriber(componentRequested, this.schema));
    }

    private List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> tryDisambiguate(AttributeMatcher matcher, List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates, ImmutableAttributes componentRequested, AttributeMatchingExplanationBuilder explanationBuilder) {
        if ((candidates = this.disambiguateWithSchema(matcher, candidates, componentRequested, explanationBuilder)).size() == 1) {
            return candidates;
        }
        if (candidates.size() == 2) {
            return this.compareCandidates(matcher, candidates.get(0), candidates.get(1)).map(Collections::singletonList).orElse(candidates);
        }
        ArrayList shortestTransforms = Lists.newArrayListWithExpectedSize((int)candidates.size());
        candidates.sort(Comparator.comparingInt(candidate -> ((ConsumerVariantMatchResult.ConsumerVariant)candidate.right).depth));
        boolean[] hasBetterMatch = new boolean[candidates.size()];
        for (int i = 0; i < candidates.size(); ++i) {
            if (hasBetterMatch[i]) continue;
            boolean candidateIsDifferent = true;
            Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant> current = candidates.get(i);
            for (int j = i + 1; j < candidates.size(); ++j) {
                if (hasBetterMatch[j]) continue;
                int index = j;
                candidateIsDifferent = this.compareCandidates(matcher, current, candidates.get(index)).map(candidate -> {
                    if (candidate != current) {
                        return false;
                    }
                    hasBetterMatch[index] = true;
                    return true;
                }).orElse(true);
            }
            if (!candidateIsDifferent) continue;
            shortestTransforms.add(current);
        }
        return shortestTransforms;
    }

    private List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> disambiguateWithSchema(AttributeMatcher matcher, List<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> candidates, ImmutableAttributes componentRequested, AttributeMatchingExplanationBuilder explanationBuilder) {
        List candidateAttributes = candidates.stream().map(pair -> ((ConsumerVariantMatchResult.ConsumerVariant)pair.getRight()).attributes).collect(Collectors.toList());
        List matches = matcher.matches(candidateAttributes, componentRequested, explanationBuilder);
        if (matches.size() == 1) {
            AttributeContainerInternal singleMatch = (AttributeContainerInternal)matches.get(0);
            return candidates.stream().filter(pair -> ((ConsumerVariantMatchResult.ConsumerVariant)pair.getRight()).attributes.equals(singleMatch)).collect(Collectors.toList());
        }
        if (matches.size() > 0 && matches.size() < candidates.size()) {
            return candidates.stream().filter(pair -> matches.contains(((ConsumerVariantMatchResult.ConsumerVariant)pair.getRight()).attributes)).collect(Collectors.toList());
        }
        return candidates;
    }

    private Optional<Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant>> compareCandidates(AttributeMatcher matcher, Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant> firstCandidate, Pair<ResolvedVariant, ConsumerVariantMatchResult.ConsumerVariant> secondCandidate) {
        if (matcher.isMatching(((ConsumerVariantMatchResult.ConsumerVariant)firstCandidate.right).attributes, ((ConsumerVariantMatchResult.ConsumerVariant)secondCandidate.right).attributes) || matcher.isMatching(((ConsumerVariantMatchResult.ConsumerVariant)secondCandidate.right).attributes, ((ConsumerVariantMatchResult.ConsumerVariant)firstCandidate.right).attributes)) {
            if (((ConsumerVariantMatchResult.ConsumerVariant)firstCandidate.right).depth >= ((ConsumerVariantMatchResult.ConsumerVariant)secondCandidate.right).depth) {
                return Optional.of(secondCandidate);
            }
            return Optional.of(firstCandidate);
        }
        return Optional.empty();
    }

    private static class TraceDiscardedVariants
    implements AttributeMatchingExplanationBuilder {
        private final Set<HasAttributes> discarded = Sets.newHashSet();

        private TraceDiscardedVariants() {
        }

        @Override
        public boolean canSkipExplanation() {
            return false;
        }

        @Override
        public <T extends HasAttributes> void candidateDoesNotMatchAttributes(T candidate, AttributeContainerInternal requested) {
            this.recordDiscardedCandidate(candidate);
        }

        public <T extends HasAttributes> void recordDiscardedCandidate(T candidate) {
            this.discarded.add(candidate);
        }

        @Override
        public <T extends HasAttributes> void candidateAttributeDoesNotMatch(T candidate, Attribute<?> attribute, Object requestedValue, AttributeValue<?> candidateValue) {
            this.recordDiscardedCandidate(candidate);
        }
    }
}

