/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.Action;
import org.gradle.api.internal.AbstractMutationGuard;

public class DefaultMutationGuard
extends AbstractMutationGuard {
    private final ThreadLocal<Boolean> mutationGuardState = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };

    @Override
    public boolean isMutationAllowed() {
        return this.mutationGuardState.get();
    }

    @Override
    protected <T> Action<? super T> newActionWithMutation(final Action<? super T> action, final boolean allowMutationMethods) {
        return new Action<T>(){

            @Override
            public void execute(T t) {
                boolean oldIsMutationAllowed = DefaultMutationGuard.this.isMutationAllowed();
                DefaultMutationGuard.this.mutationGuardState.set(allowMutationMethods);
                try {
                    action.execute(t);
                }
                finally {
                    DefaultMutationGuard.this.mutationGuardState.set(oldIsMutationAllowed);
                }
            }
        };
    }
}

