/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.j2k.J2KUtilsKt;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0018\u00010\fR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;", "", "project", "Lcom/intellij/openapi/project/Project;", "thisObject", "Lcom/sun/jdi/Value;", "variables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "(Lcom/intellij/openapi/project/Project;Lcom/sun/jdi/Value;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "getThisObject", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "", "getVariables", "()Ljava/util/List;", "Companion", "Variable", "kotlin.jvm-debugger.evaluation"})
public final class FrameInfo {
    @Nullable
    private final Variable thisObject;
    @NotNull
    private final List<Variable> variables;
    @NotNull
    private final Project project;
    private static final String FAKE_JAVA_THIS_NAME = "$this$_java_locals_debug_fun_";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Variable getThisObject() {
        return this.thisObject;
    }

    @NotNull
    public final List<Variable> getVariables() {
        return this.variables;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    private FrameInfo(Project project, Value thisObject, Map<LocalVariableProxyImpl, ? extends Value> variables) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Variable variable;
        this.project = project;
        Object object = this;
        boolean bl = false;
        boolean bl2 = false;
        FrameInfo frameInfo = object;
        FrameInfo frameInfo2 = this;
        boolean bl3 = false;
        if (thisObject == null) {
            variable = null;
        } else {
            void $this$run;
            String string = thisObject.type().name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"thisObject.type().name()");
            variable = (FrameInfo)$this$run.new Variable(FAKE_JAVA_THIS_NAME, string, thisObject);
        }
        Object object2 = variable;
        frameInfo2.thisObject = object2;
        object = variables;
        frameInfo2 = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_12 = $this$mapTo$iv$iv;
        boolean bl4 = false;
        Iterator iterator = var9_12.entrySet().iterator();
        while (iterator.hasNext()) {
            void v;
            void $dstr$v$value;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object2 = destination$iv$iv;
            boolean bl5 = false;
            void var15_18 = $dstr$v$value;
            boolean bl6 = false;
            LocalVariableProxyImpl localVariableProxyImpl = (LocalVariableProxyImpl)var15_18.getKey();
            var15_18 = $dstr$v$value;
            bl6 = false;
            Value value2 = (Value)var15_18.getValue();
            String string = v.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"v.name()");
            String string2 = v.typeName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"v.typeName()");
            Variable variable2 = new Variable(string, string2, value2);
            object2.add(variable2);
        }
        frameInfo2.variables = object2 = (List)destination$iv$iv;
    }

    public /* synthetic */ FrameInfo(Project project, Value thisObject, Map variables, DefaultConstructorMarker $constructor_marker) {
        this(project, thisObject, variables);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "", "name", "", "typeName", "value", "Lcom/sun/jdi/Value;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;Ljava/lang/String;Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getName", "()Ljava/lang/String;", "getTypeName", "getValue", "()Lcom/sun/jdi/Value;", "asProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin.jvm-debugger.evaluation"})
    public final class Variable {
        @NotNull
        private final String name;
        @NotNull
        private final String typeName;
        @Nullable
        private final Value value;

        @Nullable
        public final KtProperty asProperty() {
            if (!PsiNameHelper.getInstance((Project)FrameInfo.this.getProject()).isIdentifier(this.name)) {
                return null;
            }
            return Companion.createKotlinProperty(FrameInfo.this.getProject(), this.name, this.typeName, this.value);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        public Variable(@NotNull String name, @Nullable String typeName, Value value2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            this.name = name;
            this.typeName = typeName;
            this.value = value2;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Companion;", "", "()V", "FAKE_JAVA_THIS_NAME", "", "collectVariableValues", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "Lcom/sun/jdi/Value;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "createKotlinProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "project", "Lcom/intellij/openapi/project/Project;", "name", "typeName", "value", "from", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        @NotNull
        public final FrameInfo from(@NotNull Project project, @Nullable StackFrameProxyImpl frameProxy) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (frameProxy == null) {
                return new FrameInfo(project, null, MapsKt.emptyMap(), null);
            }
            Map<LocalVariableProxyImpl, Value> variableValues = this.collectVariableValues(frameProxy);
            return new FrameInfo(project, frameProxy.thisObject(), variableValues, null);
        }

        private final Map<LocalVariableProxyImpl, Value> collectVariableValues(StackFrameProxyImpl frameProxy) {
            List variables = SafeUtilKt.safeVisibleVariables((StackFrameProxyImpl)frameProxy);
            HashMap values = new HashMap(variables.size());
            for (LocalVariableProxyImpl variable : variables) {
                Value value2;
                if (frameProxy.getValue(variable) == null) {
                    continue;
                }
                ((Map)values).put(variable, value2);
            }
            return values;
        }

        private final KtProperty createKotlinProperty(Project project, String name, String typeName, Value value2) {
            KtProperty ktProperty;
            block1: {
                KtProperty ktProperty2;
                String className = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)typeName, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"[]", null, (int)2, null);
                PsiClassType psiClassType = PsiType.getTypeByName((String)className, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"PsiType.getTypeByName(cl\u2026hScope.allScope(project))");
                PsiClassType classType = psiClassType;
                String elementType = !(value2 instanceof PrimitiveValue) && classType.resolve() == null ? "java.lang.Object" : className;
                String propertyType = value2 instanceof ArrayReference ? elementType + "[]" : elementType;
                PsiClassType psiClassType2 = PsiType.getTypeByName((String)propertyType, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"PsiType.getTypeByName(pr\u2026hScope.allScope(project))");
                PsiClassType psiType = psiClassType2;
                PsiField psiField = PsiElementFactory.getInstance((Project)project).createField(name, (PsiType)psiType);
                Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"PsiElementFactory.getIns\u2026reateField(name, psiType)");
                PsiField field = psiField;
                KtNamedDeclaration ktNamedDeclaration = J2KUtilsKt.j2k((PsiMember)((PsiMember)field));
                if (!(ktNamedDeclaration instanceof KtProperty)) {
                    ktNamedDeclaration = null;
                }
                if ((ktProperty2 = (ktProperty = (KtProperty)ktNamedDeclaration)) == null || (ktProperty2 = ktProperty2.getModifierList()) == null) break block1;
                ktProperty2.delete();
            }
            return ktProperty;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

