/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.connect;

import com.intellij.internal.statistic.config.EventLogConfigParserException;
import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.EventLogExternalSettings;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.connect.StatisticsCachingSupplier;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.service.request.StatsHttpRequests;
import com.intellij.internal.statistic.service.request.StatsResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsConnectionService {
    @Nullable
    private final String myConfigUrl;
    @NotNull
    private final EventLogApplicationInfo myApplicationInfo;
    @NotNull
    private final Supplier<EventLogExternalSendSettings> myCachedExternalSettings;

    protected SettingsConnectionService(@Nullable String settingsUrl, @NotNull EventLogApplicationInfo appInfo, long settingsCacheTimeoutMs) {
        this.myConfigUrl = settingsUrl;
        this.myApplicationInfo = appInfo;
        this.myCachedExternalSettings = new StatisticsCachingSupplier<EventLogExternalSendSettings>(() -> this.myConfigUrl != null ? this.loadSettings(this.myConfigUrl, this.myApplicationInfo.getProductVersion()) : null, settingsCacheTimeoutMs);
    }

    @Nullable
    protected EventLogSendConfiguration getConfiguration(@NotNull EventLogBuildType type) {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        return settings != null ? settings.getConfiguration(type) : null;
    }

    @Nullable
    protected String getEndpointValue(@NotNull String attribute) {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        return settings != null ? settings.getEndpoint(attribute) : null;
    }

    @Nullable
    protected synchronized EventLogExternalSendSettings getExternalSettings() {
        return this.myCachedExternalSettings.get();
    }

    @Nullable
    public EventLogExternalSendSettings loadSettings(@NotNull String configUrl, @NotNull String appVersion) {
        try {
            return StatsHttpRequests.request(configUrl, this.myApplicationInfo.getConnectionSettings()).send(r -> {
                try {
                    InputStream content = r.read();
                    if (content != null) {
                        InputStreamReader reader = new InputStreamReader(content, StandardCharsets.UTF_8);
                        return EventLogExternalSettings.parseSendSettings((Reader)reader, (String)appVersion);
                    }
                    return null;
                }
                catch (EventLogConfigParserException e) {
                    throw new StatsResponseException(e);
                }
            }).getResult();
        }
        catch (StatsResponseException | IOException e) {
            this.logError(e);
            return null;
        }
    }

    private void logError(Exception e) {
        String message = e.getMessage();
        this.myApplicationInfo.getLogger().warn(message != null ? message : "", e);
        this.myApplicationInfo.getEventLogger().logErrorEvent("loading.config.failed", e);
    }
}

