/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameAttributeQuickFix
implements LintIdeQuickFix {
    private final String myNamespace;
    private final String myLocalName;

    public RenameAttributeQuickFix(@Nullable String namespace, @NotNull String localName) {
        this.myNamespace = namespace;
        this.myLocalName = localName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false);
        if (attribute == null) {
            return;
        }
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            return;
        }
        XmlFile xmlFile = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlFile.class);
        if (xmlFile == null) {
            return;
        }
        if (this.myNamespace != null) {
            String prefix = LintIdeSupport.get().ensureNamespaceImported(xmlFile, this.myNamespace, null);
            attribute.setName(prefix + ":" + this.myLocalName);
        } else {
            attribute.setName(this.myLocalName);
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        return "Use " + this.myLocalName;
    }
}

