/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFixProvider;
import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.lint.common.SuppressLintIntentionAction;
import com.android.tools.lint.checks.DeprecationDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.WrongIdDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Sets;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.DisableInspectionToolAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class LintExternalAnnotator
extends ExternalAnnotator<LintEditorResult, LintEditorResult> {
    static final String LINK_PREFIX = "#lint/";
    static final boolean INCLUDE_IDEA_SUPPRESS_ACTIONS = false;

    @Nullable
    public LintEditorResult collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        return this.collectInformation(file);
    }

    public LintEditorResult collectInformation(@NotNull PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        return this.collectInformation(file, module);
    }

    protected boolean isRelevant(@NotNull PsiFile file, @NotNull Module module) {
        return LintIdeSupport.get().canAnnotate(file, module);
    }

    @Nullable
    protected LintEditorResult collectInformation(@NotNull PsiFile file, @NotNull Module module) {
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        if (!this.isRelevant(file, module)) {
            return null;
        }
        Set<Issue> issues = LintExternalAnnotator.getIssuesFromInspections(file.getProject(), (PsiElement)file);
        return new LintEditorResult(module, vFile, file.getText(), issues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LintEditorResult doAnnotate(LintEditorResult lintResult) {
        long startTime = System.currentTimeMillis();
        LintIdeClient client = LintIdeSupport.get().createEditorClient(lintResult);
        try {
            EnumSet scope;
            VirtualFile mainFile = lintResult.getMainFile();
            FileType fileType = mainFile.getFileType();
            String name = mainFile.getName();
            if (fileType == XmlFileType.INSTANCE) {
                if (name.equals("AndroidManifest.xml")) {
                    scope = Scope.MANIFEST_SCOPE;
                } else {
                    if (!name.endsWith(".xml")) {
                        LintEditorResult lintEditorResult = lintResult;
                        return lintEditorResult;
                    }
                    scope = Scope.RESOURCE_FILE_SCOPE;
                }
            } else if (fileType == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE) {
                scope = Scope.JAVA_FILE_SCOPE;
                if (name.endsWith(".kts")) {
                    scope = EnumSet.of(Scope.GRADLE_FILE, Scope.JAVA_FILE);
                }
            } else if (name.equals("proguard.cfg") || name.equals("proguard-project.txt")) {
                scope = EnumSet.of(Scope.PROGUARD_FILE);
            } else if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
                scope = Scope.GRADLE_SCOPE;
            } else if (fileType == PropertiesFileType.INSTANCE) {
                scope = Scope.PROPERTY_SCOPE;
            } else {
                assert (false) : fileType;
                LintEditorResult lintEditorResult = lintResult;
                return lintEditorResult;
            }
            Project project = lintResult.getModule().getProject();
            if (project.isDisposed()) {
                LintEditorResult lintEditorResult = lintResult;
                return lintEditorResult;
            }
            if (DumbService.isDumb((Project)project)) {
                LintEditorResult lintEditorResult = lintResult;
                return lintEditorResult;
            }
            List<VirtualFile> files = Collections.singletonList(mainFile);
            LintIdeRequest request = new LintIdeRequest(client, project, files, Collections.singletonList(lintResult.getModule()), true);
            request.setScope(scope);
            LintDriver lint = client.createDriver(request);
            lint.analyze();
            lint.setAnalysisStartTime(startTime);
            LintIdeSupport.get().logSession(lint, lintResult);
            return lintResult;
        }
        finally {
            Disposer.dispose((Disposable)client);
        }
    }

    @NotNull
    static Set<Issue> getIssuesFromInspections(@NotNull Project project, @Nullable PsiElement context) {
        IssueRegistry fullRegistry = LintIdeIssueRegistry.get();
        List issueList = fullRegistry.getIssues();
        HashSet result = Sets.newHashSetWithExpectedSize((int)(issueList.size() + 10));
        for (Issue issue : issueList) {
            HighlightDisplayKey key;
            String inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
            if (inspectionShortName == null || (key = HighlightDisplayKey.find((String)inspectionShortName)) == null) continue;
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            boolean enabled = context != null ? profile.isToolEnabled(key, context) : profile.isToolEnabled(key);
            if (!enabled) continue;
            if (!issue.isEnabledByDefault()) {
                issue.setEnabledByDefault(true);
            }
            result.add(issue);
        }
        return result;
    }

    public void apply(@NotNull PsiFile file, LintEditorResult lintResult, @NotNull AnnotationHolder holder) {
        if (lintResult.isDirty()) {
            return;
        }
        Project project = file.getProject();
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        LintIdeQuickFixProvider[] fixProviders = (LintIdeQuickFixProvider[])LintIdeQuickFixProvider.EP_NAME.getExtensions();
        LintIdeSupport ideSupport = LintIdeSupport.get();
        for (LintProblemData problemData : lintResult.getProblems()) {
            LintIdeQuickFix[] fixes;
            HighlightDisplayLevel configuredLevel;
            HighlightDisplayKey key;
            Pair<AndroidLintInspectionBase, HighlightDisplayLevel> pair;
            Issue issue = problemData.getIssue();
            String message = problemData.getMessage();
            TextRange range = problemData.getTextRange();
            LintFix quickfixData = problemData.getQuickfixData();
            if (range.getStartOffset() == range.getEndOffset() || (pair = LintExternalAnnotator.getHighlightLevelAndInspection(project, issue, (PsiElement)file)) == null) continue;
            AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)((Object)pair.getFirst());
            HighlightDisplayLevel displayLevel = (HighlightDisplayLevel)pair.getSecond();
            if (inspection == null || (key = HighlightDisplayKey.find((String)inspection.getShortName())) == null) continue;
            PsiElement startElement = file.findElementAt(range.getStartOffset());
            PsiElement endElement = file.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || inspection.isSuppressedFor(startElement)) continue;
            if (problemData.getConfiguredSeverity() != null && (configuredLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(problemData.getConfiguredSeverity())) != null) {
                displayLevel = configuredLevel;
            }
            HighlightSeverity severity = displayLevel.getSeverity();
            ProblemHighlightType type = issue == DeprecationDetector.ISSUE || issue == GradleDetector.DEPRECATED || issue == GradleDetector.DEPRECATED_CONFIGURATION ? ProblemHighlightType.LIKE_DEPRECATED : (issue == WrongIdDetector.UNKNOWN_ID || issue == WrongIdDetector.UNKNOWN_ID_LAYOUT ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.ERROR ? ProblemHighlightType.GENERIC_ERROR : HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)severity)));
            String descriptionLink = "<a href=\"#lint/" + issue.getId() + "\"></a>";
            String tooltip = XmlStringUtil.wrapInHtml((CharSequence)(descriptionLink + TextFormat.RAW.convertTo(message, TextFormat.HTML)));
            AnnotationBuilder builder = holder.newAnnotation(severity, message).highlightType(type).range(range).tooltip(tooltip);
            for (LintIdeQuickFix lintIdeQuickFix : fixes = inspection.getAllFixes(startElement, endElement, message, quickfixData, fixProviders, issue)) {
                if (!lintIdeQuickFix.isApplicable(startElement, endElement, AndroidQuickfixContexts.EditorContext.TYPE)) continue;
                builder = builder.withFix((IntentionAction)new MyFixingIntention(lintIdeQuickFix, startElement, endElement));
            }
            for (LintIdeQuickFix lintIdeQuickFix : inspection.getIntentions(startElement, endElement)) {
                builder = builder.withFix((IntentionAction)lintIdeQuickFix);
            }
            if (ideSupport.canRequestFeedback()) {
                builder = builder.withFix(ideSupport.requestFeedbackIntentionAction(issue));
            }
            String id = key.getID();
            builder = builder.withFix((IntentionAction)new SuppressLintIntentionAction(id, startElement));
            builder.create();
        }
    }

    @Nullable
    public static Pair<AndroidLintInspectionBase, HighlightDisplayLevel> getHighlightLevelAndInspection(@NotNull Project project, @NotNull Issue issue, @NotNull PsiElement context) {
        String inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
        if (inspectionShortName == null) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionShortName);
        if (key == null) {
            return null;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        if (!profile.isToolEnabled(key, context) && issue.isEnabledByDefault()) {
            return null;
        }
        AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)profile.getUnwrappedTool(inspectionShortName, context);
        if (inspection == null) {
            return null;
        }
        HighlightDisplayLevel errorLevel = profile.getErrorLevel(key, context);
        return Pair.create((Object)((Object)inspection), (Object)errorLevel);
    }

    static {
        LintClient.setClientName((String)"studio");
    }

    private static class MyEditInspectionToolsSettingsAction
    extends CustomEditInspectionToolsSettingsAction {
        private MyEditInspectionToolsSettingsAction(@NotNull HighlightDisplayKey key, @NotNull AndroidLintInspectionBase inspection) {
            super(key, () -> "Edit '" + inspection.getDisplayName() + "' inspection settings");
        }
    }

    public static class MyFixingIntention
    implements IntentionAction,
    HighPriorityAction {
        private final LintIdeQuickFix myQuickFix;
        private final PsiElement myStartElement;
        private final PsiElement myEndElement;

        public MyFixingIntention(@NotNull LintIdeQuickFix quickFix, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            this.myQuickFix = quickFix;
            this.myStartElement = startElement;
            this.myEndElement = endElement;
        }

        @NotNull
        public String getText() {
            return this.myQuickFix.getName();
        }

        @NotNull
        public String getFamilyName() {
            return LintBundle.message("android.lint.quickfixes.family", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            this.myQuickFix.apply(this.myStartElement, this.myEndElement, AndroidQuickfixContexts.EditorContext.getInstance(editor));
        }

        public boolean startInWriteAction() {
            return this.myQuickFix.startInWriteAction();
        }
    }

    private static class MyDisableInspectionFix
    implements IntentionAction,
    Iconable {
        private final DisableInspectionToolAction myDisableInspectionToolAction;

        private MyDisableInspectionFix(@NotNull HighlightDisplayKey key) {
            this.myDisableInspectionToolAction = new DisableInspectionToolAction(key);
        }

        @NotNull
        public String getText() {
            return "Disable inspection";
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            this.myDisableInspectionToolAction.invoke(project, editor, file);
        }

        public boolean startInWriteAction() {
            return this.myDisableInspectionToolAction.startInWriteAction();
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
            return this.myDisableInspectionToolAction.getElementToMakeWritable(file);
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            return this.myDisableInspectionToolAction.getIcon(flags);
        }
    }
}

