/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;

public class AndroidLintMissingSuperCallInspection
extends AndroidLintInspectionBase {
    public AndroidLintMissingSuperCallInspection() {
        super(LintBundle.message("android.lint.inspections.missing.super.call", new Object[0]), CallSuperDetector.ISSUE);
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, final @Nullable LintFix fixData) {
        return new LintIdeQuickFix[]{new DefaultLintQuickFix("Add super call", true){

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(startElement)) {
                    return;
                }
                PsiMethod superMethod = (PsiMethod)LintFix.getData((LintFix)fixData, PsiMethod.class);
                if (startElement.getLanguage() == JavaLanguage.INSTANCE) {
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
                    if (method == null || method.isConstructor()) {
                        return;
                    }
                    Project project = startElement.getProject();
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    PsiStatement superStatement = factory.createStatementFromText(this.buildSuperStatement(method, superMethod), null);
                    PsiCodeBlock body = method.getBody();
                    if (body != null) {
                        PsiStatement[] statements = body.getStatements();
                        if (statements.length > 0) {
                            body.addBefore((PsiElement)superStatement, (PsiElement)statements[0]);
                        } else {
                            PsiWhiteSpace whiteSpace = (PsiWhiteSpace)PsiTreeUtil.getChildOfType((PsiElement)method.getBody(), PsiWhiteSpace.class);
                            if (whiteSpace != null && whiteSpace.getText().startsWith("\n\n")) {
                                method.getBody().replace((PsiElement)factory.createCodeBlock());
                                body = method.getBody();
                            }
                            body.add((PsiElement)superStatement);
                        }
                        PsiElement shortened = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)body);
                        CodeStyleManager.getInstance((Project)project).reformat(shortened);
                    }
                } else if (startElement.getLanguage() == KotlinLanguage.INSTANCE) {
                    KtExpression body;
                    Project project = startElement.getProject();
                    KtPsiFactory factory = new KtPsiFactory(project);
                    KtNamedFunction method = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)startElement, KtNamedFunction.class);
                    if (method == null) {
                        return;
                    }
                    String superCall = this.buildSuperStatement(method, superMethod);
                    KtExpression superStatement = factory.createExpression(superCall);
                    KtBlockExpression bodyBlock = method.getBodyBlockExpression();
                    if (bodyBlock == null && (body = method.getBodyExpression()) != null) {
                        PsiElement eq = null;
                        for (PsiElement prev = body.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
                            if (!(prev instanceof TreeElement) || ((TreeElement)prev).getElementType() != KtTokens.EQ) continue;
                            eq = prev;
                            break;
                        }
                        PsiElement parent = body.getParent();
                        bodyBlock = factory.createSingleStatementBlock(body, null, null);
                        body.delete();
                        if (eq != null) {
                            eq.delete();
                        }
                        bodyBlock = (KtBlockExpression)parent.add((PsiElement)bodyBlock);
                    }
                    if (bodyBlock != null) {
                        PsiElement lBrace = bodyBlock.getLBrace();
                        if (lBrace != null) {
                            bodyBlock.addAfter((PsiElement)superStatement, lBrace);
                        } else {
                            List statements = bodyBlock.getStatements();
                            if (!statements.isEmpty()) {
                                bodyBlock.addBefore((PsiElement)superStatement, (PsiElement)statements.get(0));
                            }
                        }
                    }
                }
            }

            @NotNull
            private String buildSuperStatement(PsiMethod method, PsiMethod superMethod) {
                PsiClass containingClass;
                PsiMethod[] superMethods;
                StringBuilder methodCallText = new StringBuilder();
                if (superMethod == null && (superMethods = method.findSuperMethods()).length > 0) {
                    superMethod = superMethods[0];
                }
                if (superMethod != null && (containingClass = superMethod.getContainingClass()) != null && containingClass.isInterface()) {
                    methodCallText.append(containingClass.getQualifiedName()).append('.');
                }
                methodCallText.append("super.").append(method.getName()).append('(');
                PsiParameter[] parameters = method.getParameterList().getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    methodCallText.append(parameters[i].getName());
                    if (i + 1 == parameters.length) continue;
                    methodCallText.append(",");
                }
                methodCallText.append(");");
                return methodCallText.toString();
            }

            @NotNull
            private String buildSuperStatement(KtNamedFunction method, PsiMethod superMethod) {
                PsiClass containingClass;
                StringBuilder methodCallText = new StringBuilder();
                if (superMethod != null && (containingClass = superMethod.getContainingClass()) != null && containingClass.isInterface()) {
                    methodCallText.append(containingClass.getQualifiedName()).append('.');
                }
                methodCallText.append("super.").append(method.getName()).append('(');
                List parameters = method.getValueParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    methodCallText.append(((KtParameter)parameters.get(i)).getName());
                    if (i + 1 == parameters.size()) continue;
                    methodCallText.append(",");
                }
                methodCallText.append(")");
                return methodCallText.toString();
            }

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                return true;
            }
        }};
    }
}

