/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.checks.ConstraintLayoutDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintGradleDependencyInspection
extends AndroidLintInspectionBase {
    public AndroidLintGradleDependencyInspection() {
        super(LintBundle.message("android.lint.inspections.gradle.dependency", new Object[0]), GradleDetector.DEPENDENCY);
    }

    public static void upgrade(@Nullable Module module) {
        if (module != null) {
            LintIdeSupport.get().updateToLatest(module, ConstraintLayoutDetector.LATEST_KNOWN_VERSION);
        }
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        Class detector = (Class)LintFix.getData((LintFix)fixData, Class.class);
        if (Objects.equals(detector, ConstraintLayoutDetector.class)) {
            return new LintIdeQuickFix[]{new UpgradeConstraintLayoutFix()};
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }

    public static class UpgradeConstraintLayoutFix
    implements LintIdeQuickFix {
        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement);
            AndroidLintGradleDependencyInspection.upgrade(module);
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            return true;
        }

        @Override
        @NotNull
        public String getName() {
            return "Upgrade to recommended version";
        }
    }
}

