/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;

public class TerminalSplitActionBase
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    private final boolean myVertically;

    private TerminalSplitActionBase(@NotNull Supplier<String> text, @Nullable Icon icon, boolean vertically) {
        this.getTemplatePresentation().setText(text);
        this.getTemplatePresentation().setIcon(icon);
        this.myVertically = vertically;
    }

    @Override
    public void actionPerformedInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content) {
        JBTerminalWidget terminalWidget = TerminalSplitActionBase.getContextTerminal(e, content);
        if (terminalWidget != null) {
            TerminalView.getInstance(project).split(terminalWidget, this.myVertically);
        }
    }

    @Nullable
    static JBTerminalWidget getContextTerminal(@NotNull AnActionEvent e, @NotNull Content content) {
        JBTerminalWidget terminal = (JBTerminalWidget)e.getDataContext().getData(JBTerminalWidget.TERMINAL_DATA_KEY);
        if (terminal != null && UIUtil.isAncestor((Component)content.getComponent(), (Component)terminal)) {
            return terminal;
        }
        return TerminalView.getWidgetByContent(content);
    }

    public static class Horizontal
    extends TerminalSplitActionBase {
        private Horizontal() {
            super(ActionsBundle.messagePointer((String)"action.SplitHorizontally.text", (Object[])new Object[0]), AllIcons.Actions.SplitHorizontally, false);
        }
    }

    public static class Vertical
    extends TerminalSplitActionBase {
        private Vertical() {
            super(ActionsBundle.messagePointer((String)"action.SplitVertically.text", (Object[])new Object[0]), AllIcons.Actions.SplitVertically, true);
        }
    }
}

