/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageBundle;
import com.intellij.execution.Executor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CoverageExecutor
extends Executor {
    public static final String EXECUTOR_ID = "Coverage";

    @NotNull
    public String getStartActionText() {
        return CoverageBundle.message("run.with.coverage", new Object[0]);
    }

    @NotNull
    public String getStartActionText(@NotNull String configurationName) {
        String configName = StringUtil.isEmpty((String)configurationName) ? "" : " '" + CoverageExecutor.shortenNameIfNeeded((String)configurationName) + "'";
        return TextWithMnemonic.parse((String)CoverageBundle.message("run.with.coverage.mnemonic", new Object[0])).replaceFirst("%s", configName).toString();
    }

    @NotNull
    public String getToolWindowId() {
        return "Run";
    }

    @NotNull
    public Icon getToolWindowIcon() {
        return AllIcons.General.RunWithCoverage;
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.General.RunWithCoverage;
    }

    public Icon getDisabledIcon() {
        return null;
    }

    public String getDescription() {
        return CoverageBundle.message("run.selected.configuration.with.coverage.enabled", new Object[0]);
    }

    @NotNull
    public String getActionName() {
        return CoverageBundle.message("action.name.cover", new Object[0]);
    }

    @NotNull
    public String getId() {
        return EXECUTOR_ID;
    }

    public String getContextActionId() {
        return "RunCoverage";
    }

    public String getHelpId() {
        return null;
    }
}

