/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.SrcFileAnnotator;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="com.intellij.coverage.CoverageDataManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class CoverageDataManagerImpl
extends CoverageDataManager
implements Disposable,
PersistentStateComponent<Element> {
    private final List<CoverageSuiteListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Logger LOG = Logger.getInstance(CoverageDataManagerImpl.class);
    @NonNls
    private static final String SUITE = "SUITE";
    private final Project myProject;
    private final Set<CoverageSuite> myCoverageSuites = new HashSet<CoverageSuite>();
    private boolean myIsProjectClosing = false;
    private final Object myLock = new Object();
    private boolean mySubCoverageIsActive;
    private final VirtualFileContentsChangedAdapter myContentListener = new VirtualFileContentsChangedAdapter(){

        protected void onFileChange(@NotNull VirtualFile fileOrDirectory) {
            if (CoverageDataManagerImpl.this.myCurrentSuiteRoots != null && VfsUtilCore.isUnder((String)fileOrDirectory.getPath(), (Collection)CoverageDataManagerImpl.this.myCurrentSuiteRoots)) {
                CoverageDataManagerImpl.this.myCurrentSuitesBundle.restoreCoverageData();
                CoverageDataManagerImpl.this.updateCoverageData(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
            }
        }

        protected void onBeforeFileChange(@NotNull VirtualFile fileOrDirectory) {
        }
    };
    private Set<LocalFileSystem.WatchRequest> myWatchRequests;
    private List<String> myCurrentSuiteRoots;
    private CoverageSuitesBundle myCurrentSuitesBundle;
    private final Object ANNOTATORS_LOCK = new Object();
    private final Map<Editor, SrcFileAnnotator> myAnnotators = new HashMap<Editor, SrcFileAnnotator>();

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        return this.myCurrentSuitesBundle;
    }

    public CoverageDataManagerImpl(final @NotNull Project project) {
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                CoverageDataManagerImpl.this.chooseSuitesBundle(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
            }
        });
        CoverageViewSuiteListener coverageViewListener = this.createCoverageViewListener();
        if (coverageViewListener != null) {
            this.addSuiteListener(coverageViewListener, this);
        }
        CoverageRunner.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageRunner>(){

            public void extensionRemoved(@NotNull CoverageRunner coverageRunner, @NotNull PluginDescriptor pluginDescriptor) {
                CoverageSuitesBundle suitesBundle = CoverageDataManagerImpl.this.getCurrentSuitesBundle();
                if (suitesBundle != null && Arrays.stream(suitesBundle.getSuites()).anyMatch(suite -> coverageRunner == suite.getRunner())) {
                    CoverageDataManagerImpl.this.chooseSuitesBundle(null);
                }
                RunManager runManager = RunManager.getInstance((Project)project);
                List configurations = runManager.getAllConfigurationsList();
                for (RunConfiguration configuration : configurations) {
                    CoverageEnabledConfiguration coverageEnabledConfiguration;
                    if (!(configuration instanceof RunConfigurationBase) || (coverageEnabledConfiguration = (CoverageEnabledConfiguration)((RunConfigurationBase)configuration).getCopyableUserData(CoverageEnabledConfiguration.COVERAGE_KEY)) == null || !Objects.equals(coverageRunner.getId(), coverageEnabledConfiguration.getRunnerId())) continue;
                    coverageEnabledConfiguration.coverageRunnerExtensionRemoved(coverageRunner);
                    ((RunConfigurationBase)configuration).putCopyableUserData(CoverageEnabledConfiguration.COVERAGE_KEY, null);
                }
                ((RunManagerImpl)runManager).reloadSchemes();
                for (CoverageSuite suite2 : CoverageDataManagerImpl.this.getSuites()) {
                    CoverageRunner runner;
                    if (!(suite2 instanceof BaseCoverageSuite) || (runner = suite2.getRunner()) != coverageRunner) continue;
                    ((BaseCoverageSuite)suite2).setRunner(null);
                }
                ActionToolbarImpl.updateAllToolbarsImmediately();
            }
        }, (Disposable)this);
        CoverageEngine.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageEngine>(){

            public void extensionRemoved(@NotNull CoverageEngine coverageEngine, @NotNull PluginDescriptor pluginDescriptor) {
                CoverageSuitesBundle suitesBundle = CoverageDataManagerImpl.this.getCurrentSuitesBundle();
                if (suitesBundle != null && suitesBundle.getCoverageEngine() == coverageEngine) {
                    CoverageDataManagerImpl.this.chooseSuitesBundle(null);
                }
                CoverageDataManagerImpl.this.myCoverageSuites.removeIf(suite -> suite.getCoverageEngine() == coverageEngine);
            }
        }, (Disposable)this);
    }

    @Nullable
    protected CoverageViewSuiteListener createCoverageViewListener() {
        return new CoverageViewSuiteListener(this, this.myProject);
    }

    public void loadState(@NotNull Element element) {
        for (Element suiteElement : element.getChildren(SUITE)) {
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(suiteElement);
            if (coverageRunner == null) {
                CoverageFileProvider fileProvider = BaseCoverageSuite.readDataFileProviderAttribute(suiteElement);
                if (!fileProvider.isValid()) continue;
                continue;
            }
            CoverageSuite suite = null;
            for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageRunner.acceptsCoverageEngine(engine) || (suite = engine.createEmptyCoverageSuite(coverageRunner)) == null) continue;
                if (!(suite instanceof BaseCoverageSuite)) break;
                ((BaseCoverageSuite)suite).setProject(this.myProject);
                break;
            }
            if (suite == null) continue;
            try {
                suite.readExternal(suiteElement);
                this.myCoverageSuites.add(suite);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        for (CoverageSuite coverageSuite : this.myCoverageSuites) {
            Element suiteElement = new Element(SUITE);
            element.addContent(suiteElement);
            coverageSuite.writeExternal(suiteElement);
        }
        return element;
    }

    @Override
    public CoverageSuite addCoverageSuite(String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, CoverageRunner coverageRunner, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled);
        if (suiteToMergeWith == null || !name.equals(suiteToMergeWith)) {
            this.removeCoverageSuite(suite);
        }
        this.myCoverageSuites.remove(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addExternalCoverageSuite(String selectedFileName, long timeStamp, CoverageRunner coverageRunner, CoverageFileProvider fileProvider) {
        CoverageSuite suite = this.createCoverageSuite(coverageRunner, selectedFileName, fileProvider, ArrayUtilRt.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        String name = config.getName() + " Coverage Results";
        String covFilePath = config.getCoverageFilePath();
        assert (covFilePath != null);
        CoverageRunner coverageRunner = config.getCoverageRunner();
        LOG.assertTrue(coverageRunner != null, (Object)("Coverage runner id = " + config.getRunnerId()));
        DefaultCoverageFileProvider fileProvider = new DefaultCoverageFileProvider(new File(covFilePath));
        CoverageSuite suite = CoverageDataManagerImpl.createCoverageSuite(config, name, coverageRunner, fileProvider);
        this.removeCoverageSuite(suite);
        this.myCoverageSuites.add(suite);
        return suite;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        suite.deleteCachedCoverageData();
        this.myCoverageSuites.remove(suite);
        if (this.myCurrentSuitesBundle != null && this.myCurrentSuitesBundle.contains(suite)) {
            Object[] suites = this.myCurrentSuitesBundle.getSuites();
            this.chooseSuitesBundle((suites = (CoverageSuite[])ArrayUtil.remove((Object[])suites, (Object)suite)).length > 0 ? new CoverageSuitesBundle((CoverageSuite[])suites) : null);
        }
    }

    @Override
    public CoverageSuite @NotNull [] getSuites() {
        return this.myCoverageSuites.toArray(new CoverageSuite[0]);
    }

    @Override
    public void chooseSuitesBundle(CoverageSuitesBundle suite) {
        if (this.myCurrentSuitesBundle == suite && suite == null) {
            return;
        }
        if (this.myWatchRequests != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myContentListener);
            this.myWatchRequests = null;
            this.myCurrentSuiteRoots = null;
        }
        this.updateCoverageData(suite);
    }

    private void updateCoverageData(CoverageSuitesBundle suite) {
        LOG.assertTrue(!this.myProject.isDefault());
        this.fireBeforeSuiteChosen();
        this.mySubCoverageIsActive = false;
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).onSuiteChosen(suite);
        }
        this.myCurrentSuitesBundle = suite;
        this.disposeAnnotators();
        if (suite == null) {
            this.triggerPresentationUpdate();
            return;
        }
        for (CoverageSuite coverageSuite : this.myCurrentSuitesBundle.getSuites()) {
            boolean suiteFileExists = coverageSuite.getCoverageDataFileProvider().ensureFileExists();
            if (suiteFileExists) continue;
            this.chooseSuitesBundle(null);
            return;
        }
        this.renewCoverageData(suite);
        this.fireAfterSuiteChosen();
    }

    @Override
    public void coverageGathered(@NotNull CoverageSuite suite) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myCurrentSuitesBundle != null) {
                int answer;
                String[] stringArray;
                String message = CoverageBundle.message("display.coverage.prompt", suite.getPresentableName());
                final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(this.myProject);
                DialogWrapper.DoNotAskOption doNotAskOption = new DialogWrapper.DoNotAskOption(){

                    public boolean isToBeShown() {
                        return coverageOptionsProvider.getOptionToReplace() == 3;
                    }

                    public void setToBeShown(boolean value, int exitCode) {
                        coverageOptionsProvider.setOptionsToReplace(value ? 3 : exitCode);
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return true;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        return UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                    }
                };
                if (this.myCurrentSuitesBundle.getCoverageEngine() == suite.getCoverageEngine()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = CoverageBundle.message("coverage.replace.active.suites", new Object[0]);
                    stringArray2[1] = CoverageBundle.message("coverage.add.to.active.suites", new Object[0]);
                    stringArray = stringArray2;
                    stringArray2[2] = CoverageBundle.message("coverage.do.not.apply.collected.coverage", new Object[0]);
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = CoverageBundle.message("coverage.replace.active.suites", new Object[0]);
                    stringArray = stringArray3;
                    stringArray3[1] = CoverageBundle.message("coverage.do.not.apply.collected.coverage", new Object[0]);
                }
                String[] options = stringArray;
                int n = answer = doNotAskOption.isToBeShown() ? Messages.showDialog((String)message, (String)CoverageBundle.message("code.coverage", new Object[0]), (String[])options, (int)1, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) : coverageOptionsProvider.getOptionToReplace();
                if (answer == 0) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                } else if (answer == 1) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])this.myCurrentSuitesBundle.getSuites(), (Object)suite)));
                }
            } else {
                this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
            }
        });
    }

    @Override
    public void triggerPresentationUpdate() {
        this.renewInformationInEditors();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ProjectView.getInstance((Project)this.myProject).refresh();
            CoverageViewManager.getInstance(this.myProject).setReady(true);
        });
    }

    @Override
    public void attachToProcess(final @NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
                handler.removeProcessListener((ProcessListener)this);
            }
        });
    }

    @Override
    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public void addRootsToWatch(List<? extends CoverageSuite> suites) {
        this.myCurrentSuiteRoots = ContainerUtil.map(suites, suite -> suite.getCoverageDataFileName());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        this.myCurrentSuiteRoots.forEach(path -> fileSystem.refreshAndFindFileByPath(path));
        this.myWatchRequests = fileSystem.addRootsToWatch(this.myCurrentSuiteRoots, true);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myContentListener);
    }

    public void dispose() {
    }

    public static void processGatheredCoverage(RunConfigurationBase configuration) {
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            coverageDataManager.coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).renewCoverageData(suite, this);
        }
    }

    private void renewInformationInEditors() {
        VirtualFile[] openFiles;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        for (VirtualFile openFile : openFiles = fileEditorManager.getOpenFiles()) {
            FileEditor[] allEditors = fileEditorManager.getAllEditors(openFile);
            this.applyInformationToEditor(allEditors, openFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyInformationToEditor(FileEditor[] editors, VirtualFile file) {
        PsiFile psiFile = (PsiFile)this.doInReadActionIfProjectOpen(() -> PsiManager.getInstance((Project)this.myProject).findFile(file));
        if (psiFile != null && this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
            SrcFileAnnotator annotator;
            Object object;
            Editor textEditor;
            CoverageEngine engine = this.myCurrentSuitesBundle.getCoverageEngine();
            if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                object = this.ANNOTATORS_LOCK;
                synchronized (object) {
                    annotator = this.myAnnotators.remove(textEditor);
                }
                if (annotator == null) break;
                Disposer.dispose((Disposable)annotator);
                break;
            }
            for (FileEditor editor : editors) {
                if (!(editor instanceof TextEditor)) continue;
                textEditor = ((TextEditor)editor).getEditor();
                annotator = this.getAnnotator(textEditor);
                if (annotator == null) {
                    annotator = new SrcFileAnnotator(psiFile, textEditor);
                    object = this.ANNOTATORS_LOCK;
                    synchronized (object) {
                        this.myAnnotators.put(textEditor, annotator);
                    }
                }
                if (this.myCurrentSuitesBundle == null || !engine.acceptedByFilters(psiFile, this.myCurrentSuitesBundle)) continue;
                annotator.showCoverageInformation(this.myCurrentSuitesBundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsProjectClosing) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        suite.restoreCoverageData();
        ProjectData data = suite.getCoverageData();
        if (data == null) {
            return;
        }
        this.mySubCoverageIsActive = true;
        HashMap<String, Set<Integer>> executionTrace = new HashMap<String, Set<Integer>>();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            suite.getCoverageEngine().collectTestLines(testNames, coverageSuite, executionTrace);
        }
        ProjectData projectData = new ProjectData();
        for (String className : executionTrace.keySet()) {
            ClassData loadedClassData = projectData.getClassData(className);
            if (loadedClassData == null) {
                loadedClassData = projectData.getOrCreateClassData(className);
            }
            Set lineNumbers = (Set)executionTrace.get(className);
            ClassData oldData = data.getClassData(className);
            LOG.assertTrue(oldData != null, (Object)("missed className: \"" + className + "\""));
            Object[] oldLines = oldData.getLines();
            LOG.assertTrue(oldLines != null);
            int maxNumber = oldLines.length;
            for (Integer lineNumber : lineNumbers) {
                if (lineNumber < maxNumber) continue;
                maxNumber = lineNumber + 1;
            }
            LineData[] lines = new LineData[maxNumber];
            for (Integer line : lineNumbers) {
                LineData oldLineData;
                int lineIdx = line - 1;
                String methodSig = null;
                if (lineIdx < oldData.getLines().length && (oldLineData = oldData.getLineData(lineIdx)) != null) {
                    methodSig = oldLineData.getMethodSignature();
                }
                LineData lineData = new LineData(lineIdx, methodSig);
                if (methodSig != null) {
                    loadedClassData.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                lines[lineIdx] = lineData;
            }
            loadedClassData.setLines(lines);
        }
        suite.setCoverageData(projectData);
        this.renewCoverageData(suite);
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        this.mySubCoverageIsActive = false;
        suite.restoreCoverageData();
        this.renewCoverageData(suite);
    }

    @Override
    public void addSuiteListener(final CoverageSuiteListener listener, Disposable parentDisposable) {
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.myListeners.remove(listener);
            }
        });
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener listener : this.myListeners) {
            listener.afterSuiteChosen();
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return this.mySubCoverageIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SrcFileAnnotator getAnnotator(Editor editor) {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            return this.myAnnotators.get(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAnnotators() {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            for (SrcFileAnnotator annotator : this.myAnnotators.values()) {
                if (annotator == null) continue;
                Disposer.dispose((Disposable)annotator);
            }
            this.myAnnotators.clear();
        }
    }

    @NotNull
    private static CoverageSuite createCoverageSuite(CoverageEnabledConfiguration config, String name, CoverageRunner coverageRunner, DefaultCoverageFileProvider fileProvider) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n = coverageEngineArray.length;
        for (int i = 0; !(i >= n || coverageRunner.acceptsCoverageEngine(engine = coverageEngineArray[i]) && engine.isApplicableTo(config.getConfiguration()) && (suite = engine.createCoverageSuite(coverageRunner, name, fileProvider, config)) != null); ++i) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        return suite;
    }

    @NotNull
    private CoverageSuite createCoverageSuite(CoverageRunner coverageRunner, String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMergeWith, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageEngine engine;
        CoverageSuite suite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n = coverageEngineArray.length;
        for (int i = 0; !(i >= n || coverageRunner.acceptsCoverageEngine(engine = coverageEngineArray[i]) && (suite = engine.createCoverageSuite(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled, false, this.myProject)) != null); ++i) {
        }
        LOG.assertTrue(suite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        return suite;
    }

    public static class CoverageProjectManagerListener
    implements ProjectManagerListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosing(@NotNull Project project) {
            CoverageDataManagerImpl manager = (CoverageDataManagerImpl)CoverageDataManager.getInstance(project);
            Object object = manager.myLock;
            synchronized (object) {
                manager.myIsProjectClosing = true;
            }
        }
    }

    public static class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        private Alarm myAlarm = null;
        private final Map<Editor, Runnable> myCurrentEditors = new HashMap<Editor, Runnable>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            PsiFile psiFile;
            Editor editor = event.getEditor();
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            CoverageDataManagerImpl manager = (CoverageDataManagerImpl)CoverageDataManager.getInstance(project);
            if (manager.myCurrentSuitesBundle != null && (psiFile = (PsiFile)ReadAction.compute(() -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = editor.getDocument();
                return documentManager.getPsiFile(document);
            })) != null && psiFile.isPhysical()) {
                CoverageEngine engine = manager.myCurrentSuitesBundle.getCoverageEngine();
                if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                    return;
                }
                SrcFileAnnotator annotator = manager.getAnnotator(editor);
                if (annotator == null) {
                    annotator = new SrcFileAnnotator(psiFile, editor);
                }
                SrcFileAnnotator finalAnnotator = annotator;
                Object object = manager.ANNOTATORS_LOCK;
                synchronized (object) {
                    manager.myAnnotators.put(editor, finalAnnotator);
                }
                Runnable request = () -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    CoverageSuitesBundle suitesBundle = manager.myCurrentSuitesBundle;
                    if (suitesBundle != null && engine.acceptedByFilters(psiFile, suitesBundle)) {
                        finalAnnotator.showCoverageInformation(suitesBundle);
                    }
                };
                this.myCurrentEditors.put(editor, request);
                this.getRequestsAlarm(manager).addRequest(request, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor = event.getEditor();
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            try {
                SrcFileAnnotator fileAnnotator;
                CoverageDataManagerImpl manager = (CoverageDataManagerImpl)CoverageDataManager.getInstance(project);
                Object object = manager.ANNOTATORS_LOCK;
                synchronized (object) {
                    fileAnnotator = (SrcFileAnnotator)manager.myAnnotators.remove(editor);
                }
                if (fileAnnotator != null) {
                    Disposer.dispose((Disposable)fileAnnotator);
                }
            }
            finally {
                Runnable request = this.myCurrentEditors.remove(editor);
                if (request != null) {
                    this.getRequestsAlarm((CoverageDataManagerImpl)CoverageDataManager.getInstance(project)).cancelRequest(request);
                }
            }
        }

        private Alarm getRequestsAlarm(@Nullable CoverageDataManagerImpl manager) {
            Alarm alarm = this.myAlarm;
            if (alarm == null) {
                this.myAlarm = alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)manager);
            }
            return alarm;
        }
    }
}

