/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.CompositeScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationCache;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationState;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsStorage;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.UtilsKt;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.idea.core.script.ucache.ScriptClassRootsUpdater;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0006H$J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\"\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u0017J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\u001c\u001a\u0004\u0018\u00010!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u001c\u001a\u0004\u0018\u00010!J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001aJ$\u0010*\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u0017H\u0002J8\u0010+\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u00172\b\b\u0002\u0010\u001e\u001a\u00020\u00172\b\b\u0002\u0010-\u001a\u00020\u00172\b\b\u0002\u0010\u001d\u001a\u00020\u0017H$J$\u0010.\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020!2\b\u0010/\u001a\u0004\u0018\u00010 2\b\b\u0002\u00100\u001a\u00020\u0017H\u0014J\u0018\u00101\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020!2\u0006\u00102\u001a\u00020 H\u0004J\u0015\u00103\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u000204H\u0000\u00a2\u0006\u0002\b5R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/DefaultScriptingSupportBase;", "", "manager", "Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "(Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;)V", "cache", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationCache;", "getCache$annotations", "()V", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationCache;", "getManager", "()Lorg/jetbrains/kotlin/idea/core/script/configuration/CompositeScriptConfigurationManager;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "collectConfigurations", "", "builder", "Lorg/jetbrains/kotlin/idea/core/script/ucache/ScriptClassRootsBuilder;", "createCache", "ensureLoadedFromCache", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "ensureUpToDatedConfigurationSuggested", "file", "skipNotification", "forceSync", "getAppliedConfiguration", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCachedConfigurationState", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationState;", "getOrLoadConfiguration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "virtualFile", "preloadedKtFile", "hasCachedConfiguration", "isConfigurationLoadingInProgress", "reloadIfOutOfDate", "reloadOutOfDateConfiguration", "isFirstLoad", "fromCacheOnly", "setAppliedConfiguration", "newConfigurationSnapshot", "syncUpdate", "setLoadedConfiguration", "configurationSnapshot", "updateScriptDependenciesSynchronously", "Lcom/intellij/psi/PsiFile;", "updateScriptDependenciesSynchronously$kotlin_core", "kotlin.core"})
public abstract class DefaultScriptingSupportBase {
    @NotNull
    private final ScriptConfigurationCache cache;
    @NotNull
    private final CompositeScriptConfigurationManager manager;

    @NotNull
    public final Project getProject() {
        return this.manager.getProject();
    }

    protected static /* synthetic */ void getCache$annotations() {
    }

    @NotNull
    protected final ScriptConfigurationCache getCache() {
        return this.cache;
    }

    @NotNull
    protected abstract ScriptConfigurationCache createCache();

    protected abstract boolean reloadOutOfDateConfiguration(@NotNull KtFile var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public static /* synthetic */ boolean reloadOutOfDateConfiguration$default(DefaultScriptingSupportBase defaultScriptingSupportBase, KtFile ktFile, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadOutOfDateConfiguration");
        }
        if ((n & 2) != 0) {
            PsiFile psiFile = ktFile.getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file.originalFile");
            boolean bl5 = bl = defaultScriptingSupportBase.getAppliedConfiguration(psiFile.getVirtualFile()) == null;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        return defaultScriptingSupportBase.reloadOutOfDateConfiguration(ktFile, bl, bl2, bl3, bl4);
    }

    @Nullable
    public final ScriptConfigurationState getCachedConfigurationState(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return this.cache.get(file);
    }

    @Nullable
    public final ScriptConfigurationSnapshot getAppliedConfiguration(@Nullable VirtualFile file) {
        ScriptConfigurationState scriptConfigurationState = this.getCachedConfigurationState(file);
        return scriptConfigurationState != null ? scriptConfigurationState.getApplied() : null;
    }

    private final boolean hasCachedConfiguration(KtFile file) {
        PsiFile psiFile = file.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file.originalFile");
        return this.getAppliedConfiguration(psiFile.getVirtualFile()) != null;
    }

    public final boolean isConfigurationLoadingInProgress(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !this.hasCachedConfiguration(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ScriptCompilationConfigurationWrapper getOrLoadConfiguration(@NotNull VirtualFile virtualFile, @Nullable KtFile preloadedKtFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ScriptConfigurationSnapshot cached = this.getAppliedConfiguration(virtualFile);
        if (cached != null) {
            return cached.getConfiguration();
        }
        KtFile ktFile = UtilsKt.getKtFile(this.getProject(), virtualFile, preloadedKtFile);
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        ScriptClassRootsUpdater this_$iv = this.manager.getUpdater();
        boolean $i$f$update = false;
        this_$iv.beginUpdating();
        try {
            boolean bl = false;
            boolean bl2 = DefaultScriptingSupportBase.reloadOutOfDateConfiguration$default(this, ktFile2, true, false, false, false, 28, null);
        }
        finally {
            this_$iv.commit();
        }
        ScriptConfigurationSnapshot scriptConfigurationSnapshot = this.getAppliedConfiguration(virtualFile);
        return scriptConfigurationSnapshot != null ? scriptConfigurationSnapshot.getConfiguration() : null;
    }

    public final void ensureUpToDatedConfigurationSuggested(@NotNull KtFile file, boolean skipNotification, boolean forceSync) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.reloadIfOutOfDate(file, skipNotification, forceSync);
    }

    public static /* synthetic */ void ensureUpToDatedConfigurationSuggested$default(DefaultScriptingSupportBase defaultScriptingSupportBase, KtFile ktFile, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ensureUpToDatedConfigurationSuggested");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        defaultScriptingSupportBase.ensureUpToDatedConfigurationSuggested(ktFile, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reloadIfOutOfDate(KtFile file, boolean skipNotification, boolean forceSync) {
        if (!ScriptDefinitionsManager.Companion.getInstance(this.getProject()).isReady()) {
            return;
        }
        ScriptClassRootsUpdater this_$iv = this.manager.getUpdater();
        boolean $i$f$update = false;
        this_$iv.beginUpdating();
        try {
            ScriptConfigurationState state;
            boolean bl = false;
            PsiFile psiFile = file.getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file.originalFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && ((state = this.cache.get(virtualFile)) == null || forceSync || !state.isUpToDate(this.getProject(), virtualFile, file))) {
                boolean bl2 = skipNotification;
                boolean bl3 = false;
                boolean bl4 = state == null;
                boolean bl5 = forceSync;
                DefaultScriptingSupportBase.reloadOutOfDateConfiguration$default(this, file, bl4, bl5, bl3, bl2, 8, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.commit();
        }
    }

    static /* synthetic */ void reloadIfOutOfDate$default(DefaultScriptingSupportBase defaultScriptingSupportBase, KtFile ktFile, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadIfOutOfDate");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        defaultScriptingSupportBase.reloadIfOutOfDate(ktFile, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean ensureLoadedFromCache(@NotNull List<? extends KtFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (!ScriptDefinitionsManager.Companion.getInstance(this.getProject()).isReady()) {
            return false;
        }
        boolean allLoaded = true;
        ScriptClassRootsUpdater this_$iv = this.manager.getUpdater();
        boolean $i$f$update = false;
        this_$iv.beginUpdating();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScriptConfigurationState state;
                KtFile file = (KtFile)element$iv;
                boolean bl2 = false;
                PsiFile psiFile = file.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file.originalFile");
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null || (state = this.cache.get(virtualFile)) != null || DefaultScriptingSupportBase.reloadOutOfDateConfiguration$default(this, file, true, false, true, false, 20, null)) continue;
                allLoaded = false;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.commit();
        }
        return allLoaded;
    }

    protected void setAppliedConfiguration(@NotNull VirtualFile file, @Nullable ScriptConfigurationSnapshot newConfigurationSnapshot, boolean syncUpdate) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.manager.getUpdater().checkInTransaction();
        ScriptConfigurationSnapshot scriptConfigurationSnapshot = newConfigurationSnapshot;
        ScriptCompilationConfigurationWrapper newConfiguration = scriptConfigurationSnapshot != null ? scriptConfigurationSnapshot.getConfiguration() : null;
        ScriptUtilsKt.scriptingDebugLog(file, (Function0<String>)((Function0)new Function0<String>(newConfiguration){
            final /* synthetic */ ScriptCompilationConfigurationWrapper $newConfiguration;

            @NotNull
            public final String invoke() {
                return "configuration changed = " + this.$newConfiguration;
            }
            {
                this.$newConfiguration = scriptCompilationConfigurationWrapper;
                super(0);
            }
        }));
        if (newConfiguration != null) {
            this.cache.setApplied(file, newConfigurationSnapshot);
            this.manager.getUpdater().invalidate(file, syncUpdate);
        }
    }

    public static /* synthetic */ void setAppliedConfiguration$default(DefaultScriptingSupportBase defaultScriptingSupportBase, VirtualFile virtualFile, ScriptConfigurationSnapshot scriptConfigurationSnapshot, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setAppliedConfiguration");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        defaultScriptingSupportBase.setAppliedConfiguration(virtualFile, scriptConfigurationSnapshot, bl);
    }

    protected final void setLoadedConfiguration(@NotNull VirtualFile file, @NotNull ScriptConfigurationSnapshot configurationSnapshot) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configurationSnapshot, (String)"configurationSnapshot");
        this.cache.setLoaded(file, configurationSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateScriptDependenciesSynchronously$kotlin_core(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (DefinitionsKt.findScriptDefinition((PsiFile)file) == null) {
            return;
        }
        PsiFile psiFile = file;
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        if ((KtFile)psiFile == null) {
            String string = "PsiFile " + file + " should be a KtFile, otherwise script dependencies cannot be loaded";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        VirtualFile virtualFile2 = virtualFile = ((KtFile)file).getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile");
        ScriptConfigurationState scriptConfigurationState = this.cache.get(virtualFile2);
        if (scriptConfigurationState != null) {
            if (scriptConfigurationState.isUpToDate(this.getProject(), virtualFile, (KtFile)file)) {
                return;
            }
        }
        ScriptClassRootsUpdater this_$iv = this.manager.getUpdater();
        boolean $i$f$update = false;
        this_$iv.beginUpdating();
        try {
            boolean bl = false;
            boolean bl2 = DefaultScriptingSupportBase.reloadOutOfDateConfiguration$default(this, (KtFile)file, false, true, false, false, 26, null);
        }
        finally {
            this_$iv.commit();
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    /*
     * WARNING - void declaration
     */
    public final void collectConfigurations(@NotNull ScriptClassRootsBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ScriptClassRootsStorage rootsStorage = ScriptClassRootsStorage.Companion.getInstance(this.getProject());
        ScriptClassRootsBuilder ownBuilder = ScriptClassRootsBuilder.Companion.fromStorage(this.getProject(), rootsStorage);
        Iterable $this$forEach$iv = this.cache.allApplied();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void vFile;
            Pair $dstr$vFile$configuration = (Pair)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)$dstr$vFile$configuration.component1();
            ScriptCompilationConfigurationWrapper configuration2 = (ScriptCompilationConfigurationWrapper)$dstr$vFile$configuration.component2();
            ownBuilder.add((VirtualFile)vFile, configuration2);
        }
        ownBuilder.toStorage(rootsStorage);
        builder.add(ownBuilder);
    }

    @NotNull
    public final CompositeScriptConfigurationManager getManager() {
        return this.manager;
    }

    public DefaultScriptingSupportBase(@NotNull CompositeScriptConfigurationManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.cache = this.createCache();
    }
}

