/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\t\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"exclusions", "", "", "shouldBeHiddenAsInternalImplementationDetail", "", "fqName", "locationFqName", "usesOutdatedCoroutinesPackage", "inFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "isExcludedFromAutoImport", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
public final class ExcludedFromImportsAndCompletionKt {
    private static final List<String> exclusions = CollectionsKt.listOf((Object[])new String[]{"kotlin.jvm.internal", "kotlin.coroutines.experimental.intrinsics", "kotlin.coroutines.intrinsics", "kotlin.coroutines.experimental.jvm.internal", "kotlin.coroutines.jvm.internal", "kotlin.reflect.jvm.internal"});

    private static final boolean shouldBeHiddenAsInternalImplementationDetail(String fqName, String locationFqName) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = exclusions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)fqName, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && (StringsKt.isBlank((CharSequence)locationFqName) || !StringsKt.startsWith$default((String)fqName, (String)locationFqName, (boolean)false, (int)2, null));
    }

    private static final boolean usesOutdatedCoroutinesPackage(String fqName, KtFile inFile) {
        return StringsKt.startsWith$default((String)fqName, (String)"kotlin.coroutines.experimental.", (boolean)false, (int)2, null) && PlatformKt.getLanguageVersionSettings((PsiElement)inFile).supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExcludedFromAutoImport(@NotNull DeclarationDescriptor $this$isExcludedFromAutoImport, @NotNull Project project, @Nullable KtFile inFile) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isExcludedFromAutoImport, (String)"$this$isExcludedFromAutoImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FqName fqName = ImportsUtils.getImportableFqName((DeclarationDescriptor)$this$isExcludedFromAutoImport);
        Object object2 = fqName;
        if (fqName == null) return false;
        String string = object2.asString();
        object2 = string;
        if (string == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"importableFqName?.asString() ?: return false");
        Object object3 = object2;
        if (JavaProjectCodeInsightSettings.getSettings((Project)project).isExcluded((String)object3)) return true;
        if (inFile != null) {
            if (ExcludedFromImportsAndCompletionKt.usesOutdatedCoroutinesPackage((String)object3, inFile)) return true;
        }
        if ((object = inFile) == null || (object = object.getPackageFqName()) == null || (object = object.asString()) == null) {
            object = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inFile?.packageFqName?.asString() ?: \"\"");
        if (!ExcludedFromImportsAndCompletionKt.shouldBeHiddenAsInternalImplementationDetail((String)object3, (String)object)) return false;
        return true;
    }
}

