/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.CommonBundle;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidSdkUtils");
    public static final String DEFAULT_PLATFORM_NAME_PROPERTY = "AndroidPlatformName";
    public static final String DEFAULT_JDK_NAME = "JDK";
    public static final String ADB_PATH_PROPERTY = "android.adb.path";

    private AndroidSdkUtils() {
    }

    @Nullable
    public static Sdk createNewAndroidPlatform(@Nullable String sdkPath, boolean promptUser) {
        Sdk sdk;
        IAndroidTarget target;
        Sdk jdk = Jdks.getInstance().chooseOrCreateJavaSdk();
        if (sdkPath != null && jdk != null && (target = AndroidSdkUtils.findBestTarget(sdkPath = FileUtil.toSystemIndependentName((String)sdkPath))) != null && (sdk = AndroidSdks.getInstance().create(target, new File(sdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target), jdk, true)) != null) {
            return sdk;
        }
        String jdkPath = jdk == null ? null : jdk.getHomePath();
        return promptUser ? AndroidSdkUtils.promptUserForSdkCreation(null, sdkPath, jdkPath) : null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull String sdkPath) {
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdkPath);
        if (sdkData != null) {
            IAndroidTarget[] targets = sdkData.getTargets();
            if (targets.length == 1) {
                return targets[0];
            }
            return AndroidSdkUtils.findBestTarget(targets);
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull IAndroidTarget[] targets) {
        IAndroidTarget bestTarget = null;
        int maxApiLevel = -1;
        for (IAndroidTarget target : targets) {
            AndroidVersion version2 = target.getVersion();
            if (!target.isPlatform() || version2.isPreview() || version2.getApiLevel() <= maxApiLevel) continue;
            bestTarget = target;
            maxApiLevel = version2.getApiLevel();
        }
        return bestTarget;
    }

    public static String getTargetPresentableName(@NotNull IAndroidTarget target) {
        return target.isPlatform() ? target.getName() : target.getName() + " (" + target.getVersionName() + ')';
    }

    public static boolean targetHasId(@NotNull IAndroidTarget target, @NotNull String id) {
        return id.equals(target.getVersion().getApiString()) || id.equals(target.getVersionName());
    }

    private static boolean tryToSetAndroidPlatform(@NotNull Module module2, @NotNull Sdk sdk) {
        AndroidPlatform platform = AndroidPlatform.parse(sdk);
        if (platform != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)sdk);
            return true;
        }
        return false;
    }

    private static void setupPlatform(@NotNull Module module2) {
        String targetHashString = AndroidSdkUtils.getTargetHashStringFromPropertyFile(module2);
        if (targetHashString != null && AndroidSdkUtils.findAndSetSdkWithHashString(module2, targetHashString)) {
            return;
        }
        PropertiesComponent component = PropertiesComponent.getInstance();
        if (component.isValueSet(DEFAULT_PLATFORM_NAME_PROPERTY)) {
            String defaultPlatformName = component.getValue(DEFAULT_PLATFORM_NAME_PROPERTY);
            Sdk defaultLib = ProjectJdkTable.getInstance().findJdk(defaultPlatformName, AndroidSdkType.getInstance().getName());
            if (defaultLib != null && AndroidSdkUtils.tryToSetAndroidPlatform(module2, defaultLib)) {
                return;
            }
        }
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
            if (platform == null || !AndroidSdkUtils.checkSdkRoots(sdk, platform.getTarget(), false) || !AndroidSdkUtils.tryToSetAndroidPlatform(module2, sdk)) continue;
            component.setValue(DEFAULT_PLATFORM_NAME_PROPERTY, sdk.getName());
            return;
        }
    }

    @Nullable
    private static String getTargetHashStringFromPropertyFile(@NotNull Module module2) {
        Pair<String, VirtualFile> targetProp = AndroidRootUtil.getProjectPropertyValue(module2, "target");
        return targetProp != null ? (String)targetProp.getFirst() : null;
    }

    private static boolean findAndSetSdkWithHashString(@NotNull Module module2, @NotNull String targetHashString) {
        Pair<String, VirtualFile> sdkDirProperty = AndroidRootUtil.getPropertyValue(module2, "local.properties", "sdk.dir");
        String sdkDir = sdkDirProperty != null ? (String)sdkDirProperty.getFirst() : null;
        return AndroidSdkUtils.findAndSetSdk(module2, targetHashString, sdkDir);
    }

    public static boolean findAndSetSdk(@NotNull Module module2, @NotNull String targetHashString, @Nullable String sdkPath) {
        Sdk sdk;
        File path2 = null;
        if (sdkPath != null) {
            path2 = new File(FileUtil.toSystemIndependentName((String)sdkPath));
        }
        if ((sdk = AndroidSdks.getInstance().findSuitableAndroidSdk(targetHashString)) != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)sdk);
            return true;
        }
        if (sdkPath != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module2, path2, targetHashString)) {
            return true;
        }
        String androidHomeValue = System.getenv("ANDROID_HOME");
        if (androidHomeValue != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module2, new File(FileUtil.toSystemIndependentName((String)androidHomeValue)), targetHashString)) {
            return true;
        }
        String androidSdkRootValue = System.getenv("ANDROID_SDK_ROOT");
        if (androidSdkRootValue != null && AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module2, new File(FileUtil.toSystemIndependentName((String)androidSdkRootValue)), targetHashString)) {
            return true;
        }
        for (File dir : AndroidSdks.getInstance().getAndroidSdkPathsFromExistingPlatforms()) {
            if (!AndroidSdkUtils.tryToCreateAndSetAndroidSdk(module2, dir, targetHashString)) continue;
            return true;
        }
        return false;
    }

    public static void updateSdkSourceRoot(@NotNull Sdk sdk) {
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform != null) {
            IAndroidTarget target = platform.getTarget();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.removeRoots(OrderRootType.SOURCES);
            AndroidSdks.getInstance().findAndSetPlatformSources(target, sdkModificator);
            sdkModificator.commitChanges();
        }
    }

    @VisibleForTesting
    static boolean tryToCreateAndSetAndroidSdk(@NotNull Module module2, @NotNull File sdkPath, @NotNull String targetHashString) {
        Sdk sdk = AndroidSdks.getInstance().tryToCreate(sdkPath, targetHashString);
        if (sdk != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)sdk);
            return true;
        }
        return false;
    }

    @Nullable
    private static Sdk promptUserForSdkCreation(@Nullable IAndroidTarget target, @Nullable String androidSdkPath, @Nullable String jdkPath) {
        Ref sdkRef = new Ref();
        Runnable task2 = () -> {
            SelectSdkDialog dlg = new SelectSdkDialog(jdkPath, androidSdkPath);
            dlg.setModal(true);
            if (dlg.showAndGet()) {
                Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target, dlg.getAndroidHome(), dlg.getJdkHome());
                sdkRef.set((Object)sdk);
                if (sdk != null) {
                    IdeSdks.updateWelcomeRunAndroidSdkAction();
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task2.run();
            return (Sdk)sdkRef.get();
        }
        application.invokeAndWait(task2, ModalityState.any());
        return (Sdk)sdkRef.get();
    }

    @Nullable
    private static Sdk createNewAndroidPlatform(@Nullable IAndroidTarget target, @NotNull String androidSdkPath, @NotNull String jdkPath) {
        if (StringUtil.isNotEmpty((String)jdkPath)) {
            jdkPath = FileUtil.toSystemIndependentName((String)jdkPath);
            Sdk jdk = Jdks.getInstance().createJdk(jdkPath);
            if (jdk != null) {
                androidSdkPath = FileUtil.toSystemIndependentName((String)androidSdkPath);
                if (target == null) {
                    target = AndroidSdkUtils.findBestTarget(androidSdkPath);
                }
                if (target != null) {
                    return AndroidSdks.getInstance().create(target, new File(androidSdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target), jdk, true);
                }
            }
        }
        return null;
    }

    public static void setupAndroidPlatformIfNecessary(@NotNull Module module2, boolean forceImportFromProperties) {
        AndroidPlatform platform;
        Sdk currentSdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (currentSdk == null || !AndroidSdks.getInstance().isAndroidSdk(currentSdk)) {
            AndroidSdkUtils.setupPlatform(module2);
            return;
        }
        if (forceImportFromProperties && (platform = AndroidPlatform.getInstance(currentSdk)) != null) {
            String targetHashString = AndroidSdkUtils.getTargetHashStringFromPropertyFile(module2);
            String currentTargetHashString = platform.getTarget().hashString();
            if (targetHashString != null && !targetHashString.equals(currentTargetHashString)) {
                AndroidSdkUtils.findAndSetSdkWithHashString(module2, targetHashString);
            }
        }
    }

    public static void openModuleDependenciesConfigurable(@NotNull Module module2) {
        ProjectSettingsService.getInstance((Project)module2.getProject()).openModuleDependenciesSettings(module2, null);
    }

    @Nullable
    public static Sdk findAppropriateAndroidPlatform(@NotNull IAndroidTarget target, @NotNull AndroidSdkData sdkData, boolean forMaven) {
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            IAndroidTarget currentTarget;
            AndroidSdkAdditionalData data;
            AndroidSdkData currentSdkData;
            String homePath = sdk.getHomePath();
            AndroidSdks androidSdks = AndroidSdks.getInstance();
            if (homePath == null || !androidSdks.isAndroidSdk(sdk) || !sdkData.equals(currentSdkData = AndroidSdkData.getSdkData(homePath)) || (data = androidSdks.getAndroidSdkAdditionalData(sdk)) == null || (currentTarget = data.getBuildTarget(currentSdkData)) == null || !target.hashString().equals(currentTarget.hashString()) || !AndroidSdkUtils.checkSdkRoots(sdk, target, forMaven)) continue;
            return sdk;
        }
        return null;
    }

    public static boolean checkSdkRoots(@NotNull Sdk sdk, @NotNull IAndroidTarget target, boolean forMaven) {
        Sdk javaSdk;
        String homePath = sdk.getHomePath();
        if (homePath == null) {
            return false;
        }
        AndroidSdks androidSdks = AndroidSdks.getInstance();
        AndroidSdkAdditionalData sdkAdditionalData = androidSdks.getAndroidSdkAdditionalData(sdk);
        Sdk sdk2 = javaSdk = sdkAdditionalData != null ? sdkAdditionalData.getJavaSdk() : null;
        if (javaSdk == null) {
            return false;
        }
        HashSet filesInSdk = Sets.newHashSet((Object[])sdk.getRootProvider().getFiles(OrderRootType.CLASSES));
        List<VirtualFile> platformAndAddOnJars = androidSdks.getPlatformAndAddOnJars(target);
        for (VirtualFile file2 : platformAndAddOnJars) {
            if (filesInSdk.contains(file2) != forMaven) continue;
            return false;
        }
        boolean containsJarFromJdk = false;
        for (VirtualFile file3 : javaSdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            if (!(file3.getFileType() instanceof ArchiveFileType) || !filesInSdk.contains(file3)) continue;
            containsJarFromJdk = true;
        }
        return containsJarFromJdk == forMaven;
    }

    @Nullable
    public static File getAdb(@Nullable Project project) {
        File adb;
        String path2 = System.getProperty(ADB_PATH_PROPERTY);
        if (path2 != null && (adb = new File(path2)).exists()) {
            return adb;
        }
        adb = null;
        if (project == null) {
            if (IdeSdks.getInstance().getAndroidSdkPath() != null) {
                adb = new File(IdeSdks.getInstance().getAndroidSdkPath(), AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
            }
        } else {
            AndroidSdkData data = AndroidSdkUtils.getProjectSdkData(project);
            if (data == null) {
                data = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
            }
            adb = data == null ? null : new File(data.getLocation(), AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
        }
        return adb != null && adb.exists() ? adb : null;
    }

    @Nullable
    public static AndroidSdkData getFirstAndroidModuleSdkData(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet2 : facets) {
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet2.getModule());
            if (androidPlatform == null) continue;
            return androidPlatform.getSdkData();
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getProjectSdkData(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null) {
            AndroidPlatform platform = AndroidPlatform.getInstance(projectSdk);
            return platform != null ? platform.getSdkData() : null;
        }
        return null;
    }

    public static boolean isAndroidSdkAvailable() {
        return AndroidSdks.getInstance().tryToChooseAndroidSdk() != null;
    }

    @NotNull
    public static String getTargetLabel(@NotNull IAndroidTarget target) {
        if (!target.isPlatform()) {
            return String.format("%1$s (API %2$s)", target.getFullName(), target.getVersion().getApiString());
        }
        AndroidVersion version2 = target.getVersion();
        if (version2.isPreview()) {
            return String.format(Locale.US, "API %d+: %s", target.getVersion().getApiLevel(), target.getName());
        }
        String name = SdkVersionInfo.getAndroidName((int)target.getVersion().getApiLevel());
        if (StringUtil.isNotEmpty((String)name)) {
            return name;
        }
        String release = target.getProperty("ro.build.version.release");
        if (release != null) {
            return String.format(Locale.US, "API %1$d: Android %2$s", version2.getApiLevel(), release);
        }
        return String.format(Locale.US, "API %1$d", version2.getApiLevel());
    }

    @Nullable
    public static AndroidDebugBridge getDebugBridge(@NotNull Project project) {
        boolean retry;
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidSdkData data = AndroidSdkUtils.getProjectSdkData(project);
        if (data == null) {
            data = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (data == null) {
            LOG.warn("Fail to find project SDK data.");
        }
        AndroidDebugBridge bridge = null;
        do {
            File adb;
            if ((adb = AndroidSdkUtils.getAdb(project)) == null) {
                LOG.error("Unable to locate adb.");
                return null;
            }
            ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(adb);
            MyMonitorBridgeConnectionTask task2 = new MyMonitorBridgeConnectionTask(project, (Future<AndroidDebugBridge>)future2);
            ProgressManager.getInstance().run((Task)task2);
            if (task2.wasCanceled()) {
                return null;
            }
            retry = false;
            try {
                bridge = (AndroidDebugBridge)future2.get();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (ExecutionException e) {
                String message2 = "ADB not responding. If you'd like to retry, then please manually kill \"" + SdkConstants.FN_ADB + "\" and click 'Restart'";
                boolean bl = retry = Messages.showYesNoDialog((Project)project, (String)message2, (String)CommonBundle.getErrorTitle(), (String)"&Restart", (String)"&Cancel", (Icon)Messages.getErrorIcon()) == 0;
            }
        } while (retry);
        return bridge;
    }

    public static void refreshLibrariesIn(@NotNull Sdk sdk) {
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        sdkModificator = sdk.getSdkModificator();
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    public static boolean isAndroidSdkManagerEnabled() {
        boolean sdkManagerDisabled = SystemProperties.getBooleanProperty((String)"android.studio.sdk.manager.disabled", (boolean)false);
        return !sdkManagerDisabled;
    }

    private static class MyMonitorBridgeConnectionTask
    extends Task.Modal {
        private final Future<AndroidDebugBridge> myFuture;
        private boolean myCancelled;

        public MyMonitorBridgeConnectionTask(@Nullable Project project, Future<AndroidDebugBridge> future2) {
            super(project, "Waiting for adb", true);
            this.myFuture = future2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            indicator.setIndeterminate(true);
            while (!this.myFuture.isDone()) {
                try {
                    this.myFuture.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!indicator.isCanceled()) continue;
                return;
            }
        }

        public void onCancel() {
            this.myCancelled = true;
        }

        public boolean wasCanceled() {
            return this.myCancelled;
        }
    }
}

