/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.utils.SdkUtils;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidExtractAsIncludeAction
extends AndroidBaseLayoutRefactoringAction {
    @NonNls
    public static final String ACTION_ID = "AndroidExtractAsIncludeAction";
    private final MyTestConfig myTestConfig;

    public AndroidExtractAsIncludeAction() {
        this.myTestConfig = null;
    }

    public AndroidExtractAsIncludeAction(@Nullable MyTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags2) {
        if (tags2.length == 0) {
            return;
        }
        PsiFile file2 = tags2[0].getContainingFile();
        if (file2 == null) {
            return;
        }
        XmlTag startTag = null;
        XmlTag endTag = null;
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        for (XmlTag tag : tags2) {
            int end;
            TextRange range = tag.getTextRange();
            int start2 = range.getStartOffset();
            if (start2 < startOffset) {
                startOffset = start2;
                startTag = tag;
            }
            if ((end = range.getEndOffset()) <= endOffset) continue;
            endOffset = end;
            endTag = tag;
        }
        assert (startTag != null && endTag != null);
        this.doRefactorForPsiRange(project, file2, (PsiElement)startTag, (PsiElement)endTag);
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags2) {
        if (tags2.length == 0) {
            return false;
        }
        DomManager domManager = DomManager.getDomManager((Project)tags2[0].getProject());
        boolean containsViewElement = false;
        for (XmlTag tag : tags2) {
            DomElement domElement = domManager.getDomElement(tag);
            if (!AndroidExtractAsIncludeAction.isSuitableDomElement(domElement)) {
                return false;
            }
            if (!(domElement instanceof LayoutViewElement)) continue;
            containsViewElement = true;
        }
        if (!containsViewElement) {
            return false;
        }
        PsiElement parent = tags2[0].getParent();
        if (!(parent instanceof XmlTag) || parent.getContainingFile() == null) {
            return false;
        }
        for (int i2 = 1; i2 < tags2.length; ++i2) {
            if (tags2[i2].getParent() == parent) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doRefactorForPsiRange(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement from, @NotNull PsiElement to) {
        PsiDirectory dir = file2.getContainingDirectory();
        if (dir == null) {
            return;
        }
        final AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)from);
        assert (facet2 != null);
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)from, XmlTag.class);
        assert (parentTag != null);
        List<XmlTag> tagsInRange = AndroidExtractAsIncludeAction.collectAllTags(from, to);
        assert (!tagsInRange.isEmpty()) : "there is no tag inside the range";
        final String fileName = this.myTestConfig != null ? this.myTestConfig.myLayoutFileName : null;
        String dirName = dir.getName();
        final FolderConfiguration config = !dirName.isEmpty() ? FolderConfiguration.getConfig((String[])dirName.split("-")) : null;
        String title = "Extract Android Layout";
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> CommandProcessor.getInstance().executeCommand(project, new Runnable((DataContext)dataContext, file2, from, to, parentTag, tagsInRange){
            final /* synthetic */ DataContext val$dataContext;
            final /* synthetic */ PsiFile val$file;
            final /* synthetic */ PsiElement val$from;
            final /* synthetic */ PsiElement val$to;
            final /* synthetic */ XmlTag val$parentTag;
            final /* synthetic */ List val$tagsInRange;
            {
                this.val$dataContext = dataContext;
                this.val$file = psiFile2;
                this.val$from = psiElement;
                this.val$to = psiElement2;
                this.val$parentTag = xmlTag;
                this.val$tagsInRange = list;
            }

            @Override
            public void run() {
                final XmlFile newFile = CreateResourceFileAction.createFileResource(facet2, ResourceFolderType.LAYOUT, fileName, "temp_root", config, true, "Extract Android Layout", null, this.val$dataContext);
                if (newFile != null) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            AndroidExtractAsIncludeAction.doRefactor(facet2, val$file, newFile, val$from, val$to, val$parentTag, val$tagsInRange.size() > 1);
                        }
                    });
                }
            }
        }, "Extract Android Layout", null, UndoConfirmationPolicy.REQUEST_CONFIRMATION));
    }

    private static void doRefactor(AndroidFacet facet2, PsiFile file2, XmlFile newFile, PsiElement from, PsiElement to, XmlTag parentTag, boolean wrapWithMerge) {
        Project project = facet2.getModule().getProject();
        String textToExtract = file2.getText().substring(from.getTextRange().getStartOffset(), to.getTextRange().getEndOffset());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument((PsiFile)newFile);
        assert (document != null);
        document.setText((CharSequence)("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + (wrapWithMerge ? "<merge>\n" + textToExtract + "\n</merge>" : textToExtract)));
        documentManager.commitDocument(document);
        final HashSet unknownPrefixes = new HashSet();
        newFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                String prefix = tag.getNamespacePrefix();
                if (!unknownPrefixes.contains(prefix) && tag.getNamespace().isEmpty()) {
                    unknownPrefixes.add(prefix);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                String prefix = attribute.getNamespacePrefix();
                if (!unknownPrefixes.contains(prefix) && attribute.getNamespace().isEmpty()) {
                    unknownPrefixes.add(prefix);
                }
            }
        });
        XmlTag rootTag = newFile.getRootTag();
        assert (rootTag != null);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        XmlAttribute[] attributes = rootTag.getAttributes();
        XmlAttribute firstAttribute = attributes.length > 0 ? attributes[0] : null;
        for (String prefix : unknownPrefixes) {
            String namespace = parentTag.getNamespaceByPrefix(prefix);
            String xmlNsAttrName = "xmlns:" + prefix;
            if (namespace.isEmpty() || rootTag.getAttribute(xmlNsAttrName) != null) continue;
            XmlAttribute xmlnsAttr = elementFactory.createXmlAttribute(xmlNsAttrName, namespace);
            if (firstAttribute != null) {
                rootTag.addBefore((PsiElement)xmlnsAttr, (PsiElement)firstAttribute);
                continue;
            }
            rootTag.add((PsiElement)xmlnsAttr);
        }
        String includingLayout = "@layout/" + SdkUtils.fileNameToResourceName((String)file2.getName());
        IncludeReference.setIncludingLayout(project, newFile, includingLayout);
        String resourceName = SdkUtils.fileNameToResourceName((String)newFile.getName());
        XmlTag includeTag = elementFactory.createTagFromText((CharSequence)("<include layout=\"@layout/" + resourceName + "\"/>"));
        parentTag.addAfter((PsiElement)includeTag, to);
        parentTag.deleteChildRange(from, to);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformat((PsiElement)newFile);
    }

    @NotNull
    private static List<XmlTag> collectAllTags(PsiElement from, PsiElement to) {
        PsiElement e;
        ArrayList<XmlTag> result2 = new ArrayList<XmlTag>();
        for (e = from; e != null; e = e.getNextSibling()) {
            if (e instanceof XmlTag) {
                result2.add((XmlTag)e);
            }
            if (e == to) break;
        }
        assert (e != null) : "invalid range";
        return result2;
    }

    @Override
    protected boolean isEnabledForPsiRange(@NotNull PsiElement from, @Nullable PsiElement to) {
        DomManager domManager = DomManager.getDomManager((Project)from.getProject());
        boolean containsViewElement = false;
        for (PsiElement e = from; e != null; e = e.getNextSibling()) {
            if (e instanceof XmlTag) {
                DomElement domElement = domManager.getDomElement((XmlTag)e);
                if (!AndroidExtractAsIncludeAction.isSuitableDomElement(domElement)) {
                    return false;
                }
                if (domElement instanceof LayoutViewElement) {
                    containsViewElement = true;
                }
            }
            if (e == to) break;
        }
        return containsViewElement;
    }

    private static boolean isSuitableDomElement(DomElement element2) {
        return element2 instanceof LayoutViewElement || element2 instanceof Include;
    }

    static class MyTestConfig {
        private final String myLayoutFileName;

        MyTestConfig(@NotNull String layoutFileName) {
            this.myLayoutFileName = layoutFileName;
        }
    }
}

