/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRegisterComponentAction
extends AbstractIntentionAction
implements HighPriorityAction {
    abstract boolean isAvailable(@NotNull PsiClass var1, @NotNull Manifest var2);

    abstract void invoke(@NotNull PsiClass var1, @NotNull Manifest var2);

    public final void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2) throws IncorrectOperationException {
        PsiFile manifestFile;
        Manifest manifest;
        PsiClass psiClass;
        PsiClass psiClass2 = psiClass = editor2 == null ? null : AbstractRegisterComponentAction.extractClass(editor2, file2);
        if (psiClass == null) {
            return;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        Manifest manifest2 = manifest = facet2 == null ? null : Manifest.getMainManifest(facet2);
        if (manifest == null) {
            return;
        }
        XmlElement element2 = manifest.getXmlElement();
        PsiFile psiFile2 = manifestFile = element2 == null ? null : element2.getContainingFile();
        if (manifestFile == null) {
            return;
        }
        new WriteCommandAction.Simple(project, new PsiFile[]{file2, manifestFile}){

            protected void run() throws Throwable {
                AbstractRegisterComponentAction.this.invoke(psiClass, manifest);
            }
        }.execute();
    }

    public final boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2) {
        PsiClass psiClass;
        PsiClass psiClass2 = psiClass = editor2 == null ? null : AbstractRegisterComponentAction.extractClass(editor2, file2);
        if (psiClass == null) {
            return false;
        }
        int elementOffset = editor2.getCaretModel().getOffset();
        PsiElement lBrace = psiClass.getLBrace();
        if (lBrace == null || elementOffset >= lBrace.getTextOffset()) {
            return false;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (psiClass.getQualifiedName() == null || modifierList == null || !modifierList.hasExplicitModifier("public")) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return false;
        }
        Manifest manifest = Manifest.getMainManifest(facet2);
        if (manifest == null) {
            return false;
        }
        return this.isAvailable(psiClass, manifest);
    }

    @Nullable
    public static PsiClass extractClass(@Nullable Editor editor2, @Nullable PsiFile file2) {
        if (editor2 == null || file2 == null) {
            return null;
        }
        int elementOffset = editor2.getCaretModel().getOffset();
        PsiElement element2 = file2.findElementAt(elementOffset);
        if (element2 == null) {
            return null;
        }
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiClass.class);
    }
}

