/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class TypographyQuickFix
implements LintIdeQuickFix {
    private final Issue myIssue;
    private final String myMessage;

    public TypographyQuickFix(@NotNull Issue issue2, @NotNull String message2) {
        this.myIssue = issue2;
        this.myMessage = message2;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        if (tag == null) {
            return;
        }
        for (PsiElement child : tag.getChildren()) {
            XmlText xmlText;
            String value2;
            if (!(child instanceof XmlText) || (value2 = (xmlText = (XmlText)child).getValue()) == null) continue;
            List edits = TypographyDetector.getEdits((String)this.myIssue.getId(), (String)this.myMessage, (String)value2);
            StringBuilder builder2 = new StringBuilder(value2);
            for (TypographyDetector.ReplaceEdit edit : edits) {
                String with2 = edit.replaceWith;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    with2 = with2.replace('\u2013', '~').replace('\u2018', '{').replace('\u2019', '}');
                }
                builder2.replace(edit.offset, edit.offset + edit.length, with2);
            }
            String newValue = builder2.toString();
            if (newValue.equals(value2)) continue;
            xmlText.setValue(newValue);
        }
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @NotNull
    public String getName() {
        return AndroidBundle.message("android.lint.fix.replace.with.suggested.characters", new Object[0]);
    }
}

