/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.CustomArrangementOrderToken;
import java.util.Comparator;
import org.jetbrains.android.formatter.AttributeComparator;
import org.jetbrains.annotations.NotNull;

final class AndroidAttributeOrder
extends CustomArrangementOrderToken {
    static final String ID = "ANDROID_ATTRIBUTE_ORDER";
    static final AndroidAttributeOrder INSTANCE = new AndroidAttributeOrder();

    private AndroidAttributeOrder() {
        super(ID, "Android attribute order");
    }

    @NotNull
    public Comparator<ArrangementEntry> getEntryComparator() {
        return new AttributeComparator<ArrangementEntry>(AndroidAttributeOrder::getLocalPart);
    }

    @NotNull
    private static String getLocalPart(@NotNull ArrangementEntry attribute) {
        if (!(attribute instanceof NameAwareArrangementEntry)) {
            throw new IllegalArgumentException(attribute.getClass().toString());
        }
        String qualifiedName = ((NameAwareArrangementEntry)attribute).getName();
        assert (qualifiedName != null);
        int index2 = qualifiedName.indexOf(58);
        return index2 == -1 ? qualifiedName : qualifiedName.substring(index2 + 1);
    }
}

