/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.util.PropertiesFiles;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidDexCompiler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class AndroidRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.facet.AndroidRootUtil");
    @NonNls
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "default.properties";

    private AndroidRootUtil() {
    }

    @Nullable
    public static VirtualFile getPrimaryManifestFile(@NotNull AndroidFacet facet2) {
        if (facet2.isDisposed()) {
            return null;
        }
        return SourceProviderManager.getInstance(facet2).getMainManifestFile();
    }

    @Nullable
    public static VirtualFile getCustomManifestFileForCompiler(@NotNull AndroidFacet facet2) {
        return AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), facet2.getProperties().CUSTOM_COMPILER_MANIFEST, false);
    }

    @Nullable
    public static VirtualFile getManifestFileForCompiler(@NotNull AndroidFacet facet2) {
        return facet2.getProperties().USE_CUSTOM_COMPILER_MANIFEST ? AndroidRootUtil.getCustomManifestFileForCompiler(facet2) : AndroidRootUtil.getPrimaryManifestFile(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getResourceDir(@NotNull AndroidFacet facet2) {
        return ResourceFolderManager.getInstance(facet2).getPrimaryFolder();
    }

    @Nullable
    private static String suggestResourceDirPath(@NotNull AndroidFacet facet2) {
        Module module2 = facet2.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (contentRoots.length == 0) {
            return null;
        }
        VirtualFile root2 = contentRoots[0];
        if (contentRoots.length > 1) {
            String moduleFileParentDirPath = FileUtil.toSystemIndependentName((String)new File(module2.getModuleFilePath()).getParent());
            VirtualFile moduleFileParentDir = LocalFileSystem.getInstance().findFileByPath(moduleFileParentDirPath);
            if (moduleFileParentDir != null) {
                for (VirtualFile contentRoot : contentRoots) {
                    if (!Objects.equals(contentRoot, moduleFileParentDir)) continue;
                    root2 = contentRoot;
                }
            }
        }
        return root2.getPath() + facet2.getProperties().RES_FOLDER_RELATIVE_PATH;
    }

    @Deprecated
    @Nullable
    public static String getResourceDirPath(@NotNull AndroidFacet facet2) {
        VirtualFile resourceDir = AndroidRootUtil.getResourceDir(facet2);
        return resourceDir != null ? resourceDir.getPath() : AndroidRootUtil.suggestResourceDirPath(facet2);
    }

    @Nullable
    public static VirtualFile getFileByRelativeModulePath(Module module2, String relativePath, boolean lookInContentRoot) {
        return AndroidProjectRootUtil.getFileByRelativeModulePath(module2, relativePath, lookInContentRoot);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAssetsDir(@NotNull AndroidFacet facet2) {
        return AndroidProjectRootUtil.getAssetsDir(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getLibsDir(@NotNull AndroidFacet facet2) {
        return AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), facet2.getProperties().LIBS_FOLDER_RELATIVE_PATH, false);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAidlGenDir(@NotNull AndroidFacet facet2) {
        return AndroidProjectRootUtil.getAidlGenDir(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getAaptGenDir(@NotNull AndroidFacet facet2) {
        String genPath = AndroidRootUtil.getAptGenSourceRootPath(facet2);
        return genPath != null ? LocalFileSystem.getInstance().findFileByPath(genPath) : null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getRenderscriptGenDir(@NotNull AndroidFacet facet2) {
        return AndroidProjectRootUtil.getRenderscriptGenDir(facet2);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getBuildconfigGenDir(@NotNull AndroidFacet facet2) {
        String path2 = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet2);
        return path2 != null ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
    }

    private static void collectClassFilesAndJars(@NotNull VirtualFile root2, @NotNull Set<VirtualFile> result2, @NotNull Set<VirtualFile> visited) {
        if (!visited.add(root2)) {
            return;
        }
        for (VirtualFile child : root2.getChildren()) {
            if (!child.exists()) continue;
            if (child.isDirectory()) {
                AndroidRootUtil.collectClassFilesAndJars(child, result2, visited);
                continue;
            }
            if (!"jar".equals(child.getExtension()) && !"class".equals(child.getExtension())) continue;
            if (child.getFileSystem() instanceof JarFileSystem) {
                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(child);
                if (localFile == null) continue;
                result2.add(localFile);
                continue;
            }
            result2.add(child);
        }
    }

    private static void fillExternalLibrariesAndModules(@NotNull Module module2, @NotNull Set<VirtualFile> outputDirs, @NotNull Set<Module> visited, @Nullable Set<VirtualFile> libraries, boolean exportedLibrariesOnly, boolean recursive) {
        if (!visited.add(module2)) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)module2);
            for (OrderEntry entry : manager.getOrderEntries()) {
                Module depModule;
                if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE) continue;
                if (libraries != null && entry instanceof LibraryOrderEntry) {
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null || exportedLibrariesOnly && !libraryOrderEntry.isExported()) continue;
                    for (VirtualFile file2 : library.getFiles(OrderRootType.CLASSES)) {
                        if (!file2.exists()) continue;
                        if (file2.getFileType() instanceof ArchiveFileType) {
                            if (file2.getFileSystem() instanceof JarFileSystem) {
                                VirtualFile localFile = JarFileSystem.getInstance().getVirtualFileForJar(file2);
                                if (localFile == null) continue;
                                libraries.add(localFile);
                                continue;
                            }
                            libraries.add(file2);
                            continue;
                        }
                        if (!file2.isDirectory() || file2.getFileSystem() instanceof JarFileSystem) continue;
                        AndroidRootUtil.collectClassFilesAndJars(file2, libraries, new HashSet<VirtualFile>());
                    }
                    continue;
                }
                if (!(entry instanceof ModuleOrderEntry) || (depModule = ((ModuleOrderEntry)entry).getModule()) == null) continue;
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)depModule);
                boolean libraryProject = facet2 != null && ((AndroidFacetConfiguration)facet2.getConfiguration()).isLibraryProject();
                CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)depModule);
                if (extension != null) {
                    VirtualFile classDir = extension.getCompilerOutputPath();
                    if (libraryProject) {
                        VirtualFile packedClassesJar;
                        VirtualFile tmpArtifactsDir = AndroidDexCompiler.getOutputDirectoryForDex(depModule);
                        if (tmpArtifactsDir != null && (packedClassesJar = tmpArtifactsDir.findChild("classes.jar")) != null) {
                            outputDirs.add(packedClassesJar);
                        }
                    } else if (facet2 == null && !outputDirs.contains(classDir) && classDir != null && classDir.exists()) {
                        outputDirs.add(classDir);
                    }
                }
                if (!recursive) continue;
                AndroidRootUtil.fillExternalLibrariesAndModules(depModule, outputDirs, visited, libraries, !libraryProject || exportedLibrariesOnly, true);
            }
        });
    }

    @NotNull
    public static List<VirtualFile> getExternalLibraries(Module module2) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        OrderedSet libs = new OrderedSet();
        AndroidRootUtil.fillExternalLibrariesAndModules(module2, files2, new HashSet<Module>(), (Set<VirtualFile>)libs, false, true);
        AndroidRootUtil.addAnnotationsJar(module2, (OrderedSet<VirtualFile>)libs);
        return libs;
    }

    private static void addAnnotationsJar(@NotNull Module module2, @NotNull OrderedSet<VirtualFile> libs) {
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        if (sdk == null || !AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return;
        }
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath == null) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module2);
        if (platform != null && platform.needToAddAnnotationsJarToClasspath()) {
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkHomePath) + "/tools/support/annotations.jar";
            VirtualFile annotationsJar = LocalFileSystem.getInstance().findFileByPath(annotationsJarPath);
            if (annotationsJar != null) {
                libs.add((Object)annotationsJar);
            }
        }
    }

    @Deprecated
    @NotNull
    public static Set<VirtualFile> getDependentModules(@NotNull Module module2, @NotNull VirtualFile moduleOutputDir) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        AndroidRootUtil.fillExternalLibrariesAndModules(module2, files2, new HashSet<Module>(), null, false, true);
        files2.remove(moduleOutputDir);
        return files2;
    }

    @NotNull
    public static VirtualFile[] getResourceOverlayDirs(@NotNull AndroidFacet facet2) {
        List overlayFolders = facet2.getProperties().RES_OVERLAY_FOLDERS;
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (String overlayFolder : overlayFolders) {
            VirtualFile overlayDir = AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), overlayFolder, true);
            if (overlayDir == null) continue;
            result2.add(overlayDir);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @Nullable
    public static @SystemIndependent String getModuleDirPath(@NotNull Module module2) {
        return AndroidProjectRootUtil.getModuleDirPath(module2);
    }

    @Nullable
    public static File findModuleRootFolderPath(@NotNull Module module2) {
        @SystemIndependent String path2 = AndroidRootUtil.getModuleDirPath(module2);
        if (path2 == null) {
            return null;
        }
        return new File(PathUtil.toSystemDependentName((String)path2));
    }

    @Deprecated
    @Nullable
    public static String getRenderscriptGenSourceRootPath(@NotNull AndroidFacet facet2) {
        return AndroidProjectRootUtil.getRenderscriptGenSourceRootPath(facet2);
    }

    @Deprecated
    @Nullable
    public static String getBuildconfigGenSourceRootPath(@NotNull AndroidFacet facet2) {
        return AndroidRootUtil.getAptGenSourceRootPath(facet2);
    }

    @Nullable
    public static VirtualFile getMainContentRoot(@NotNull AndroidFacet facet2) {
        Module module2 = facet2.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (contentRoots.length == 0) {
            return null;
        }
        if (contentRoots.length == 1) {
            return contentRoots[0];
        }
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet2);
        if (manifestFile != null) {
            for (VirtualFile root2 : contentRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root2, (VirtualFile)manifestFile, (boolean)true)) continue;
                return root2;
            }
        }
        return contentRoots[0];
    }

    @Deprecated
    @Nullable
    public static Pair<PropertiesFile, VirtualFile> findPropertyFile(@NotNull Module module2, @NotNull String propertyFileName) {
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            PsiFile psiFile2;
            VirtualFile vFile = contentRoot.findChild(propertyFileName);
            if (vFile == null || !((psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)module2.getProject(), (VirtualFile)vFile)) instanceof PropertiesFile)) continue;
            return Pair.create((Object)((PropertiesFile)psiFile2), (Object)vFile);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Pair<Properties, VirtualFile> readPropertyFile(@NotNull Module module2, @NotNull String propertyFileName) {
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            Pair<Properties, VirtualFile> result2 = AndroidRootUtil.readPropertyFile(contentRoot, propertyFileName);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Pair<Properties, VirtualFile> readProjectPropertyFile(@NotNull Module module2) {
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(module2, "project.properties");
        return pair != null ? pair : AndroidRootUtil.readPropertyFile(module2, DEFAULT_PROPERTIES_FILE_NAME);
    }

    @Deprecated
    @Nullable
    private static Pair<Properties, VirtualFile> readPropertyFile(@NotNull VirtualFile contentRoot, @NotNull String propertyFileName) {
        VirtualFile vFile = contentRoot.findChild(propertyFileName);
        if (vFile != null) {
            try {
                File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
                Properties properties2 = PropertiesFiles.getProperties(file2);
                return Pair.create((Object)properties2, (Object)vFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Pair<Properties, VirtualFile> readProjectPropertyFile(@NotNull VirtualFile contentRoot) {
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(contentRoot, "project.properties");
        return pair != null ? pair : AndroidRootUtil.readPropertyFile(contentRoot, DEFAULT_PROPERTIES_FILE_NAME);
    }

    @Nullable
    public static Pair<String, VirtualFile> getPropertyValue(@NotNull Module module2, @NotNull String propertyFileName, @NotNull String propertyKey) {
        String value2;
        Pair<Properties, VirtualFile> pair = AndroidRootUtil.readPropertyFile(module2, propertyFileName);
        if (pair != null && (value2 = ((Properties)pair.first).getProperty(propertyKey)) != null) {
            return Pair.create((Object)value2, (Object)pair.second);
        }
        return null;
    }

    @Nullable
    public static Pair<String, VirtualFile> getProjectPropertyValue(@NotNull Module module2, @NotNull String propertyName) {
        Pair<String, VirtualFile> result2 = AndroidRootUtil.getPropertyValue(module2, "project.properties", propertyName);
        return result2 != null ? result2 : AndroidRootUtil.getPropertyValue(module2, DEFAULT_PROPERTIES_FILE_NAME, propertyName);
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAptGenSourceRootPath(@NotNull AndroidFacet facet2) {
        return AndroidProjectRootUtil.getAptGenSourceRootPath(facet2);
    }

    @Deprecated
    @Nullable
    public static @SystemIndependent String getAidlGenSourceRootPath(@NotNull AndroidFacet facet2) {
        return AndroidProjectRootUtil.getAidlGenSourceRootPath(facet2);
    }

    @Nullable
    public static @SystemIndependent String getPathRelativeToModuleDir(@NotNull Module module2, @NotNull String path2) {
        @SystemIndependent String moduleDirPath = AndroidRootUtil.getModuleDirPath(module2);
        if (moduleDirPath == null) {
            return null;
        }
        if (moduleDirPath.equals(path2)) {
            return "";
        }
        return FileUtil.getRelativePath((String)moduleDirPath, (String)path2, (char)'/');
    }
}

