/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidFacetScopedService
implements Disposable {
    private final Object myLock = new Object();
    private AndroidFacet myFacet;
    private boolean myDisposed;

    protected AndroidFacetScopedService(@NotNull AndroidFacet facet2) {
        this.myFacet = facet2;
        Disposer.register((Disposable)facet2, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        this.onDispose();
        Object object = this.myLock;
        synchronized (object) {
            this.onServiceDisposal(this.myFacet);
            this.myFacet = null;
            this.myDisposed = true;
        }
    }

    protected void onDispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDisposed() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDisposed;
        }
    }

    @NotNull
    protected final Module getModule() {
        return this.getFacet().getModule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AndroidFacet getFacet() {
        AndroidFacet facet2;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                throw new IllegalStateException(this.getClass().getName() + " is disposed");
            }
            assert (this.myFacet != null && !this.myFacet.isDisposed());
            facet2 = this.myFacet;
        }
        return facet2;
    }

    protected abstract void onServiceDisposal(@NotNull AndroidFacet var1);
}

