/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.android.tools.idea.res.psi.ResourceNavigationItem;
import com.google.common.base.Stopwatch;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyValueResourceElementWrapper
extends RenameableFakePsiElement
implements PsiTarget,
Comparable<LazyValueResourceElementWrapper> {
    private static final Logger LOG = Logger.getInstance(LazyValueResourceElementWrapper.class);
    private final ValueResourceInfo myResourceInfo;
    private final PsiElement myParent;

    public LazyValueResourceElementWrapper(@NotNull ValueResourceInfo resourceInfo, @NotNull PsiElement parent) {
        super(parent);
        this.myParent = parent;
        this.myResourceInfo = resourceInfo;
    }

    @NotNull
    public String getName() {
        return this.myResourceInfo.getName();
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        XmlAttributeValue element2 = this.computeElement();
        if (element2 == null) {
            throw new IncorrectOperationException("Cannot find resource '" + this.myResourceInfo.getName() + "' in file " + this.myResourceInfo.getContainingFile().getPath());
        }
        return new ValueResourceElementWrapper(element2).setName(name);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ResourceNavigationItem.ResourceItemPresentation(this.myResourceInfo.getResource(), this.myResourceInfo.getContainingFile());
    }

    @Nullable
    public XmlAttributeValue computeElement() {
        if (LOG.isDebugEnabled()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            XmlAttributeValue value2 = this.myResourceInfo.computeXmlElement();
            LOG.debug("Computing XML element for lazy resource: " + this.myResourceInfo + ", time: " + stopwatch);
            return value2;
        }
        return this.myResourceInfo.computeXmlElement();
    }

    @NotNull
    public Language getLanguage() {
        return this.myParent.getLanguage();
    }

    public PsiFile getContainingFile() {
        return PsiManager.getInstance((Project)this.myParent.getProject()).findFile(this.myResourceInfo.getContainingFile());
    }

    @Nullable
    public TextRange getTextRange() {
        return this.getNavigationElement().getTextRange();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlAttributeValue element2 = this.myResourceInfo.computeXmlElement();
        return element2 != null ? element2 : this.myParent;
    }

    @NotNull
    public ValueResourceInfo getResourceInfo() {
        return this.myResourceInfo;
    }

    @NotNull
    public String getTypeName() {
        return "Android Value Resource";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public static PsiElement computeLazyElement(PsiElement element2) {
        if (element2 instanceof LazyValueResourceElementWrapper) {
            element2 = ((LazyValueResourceElementWrapper)element2).computeElement();
        }
        return element2;
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof LazyValueResourceElementWrapper) {
            return this.myResourceInfo.equals(((LazyValueResourceElementWrapper)another).getResourceInfo());
        }
        return super.isEquivalentTo(another);
    }

    @Override
    public int compareTo(@NotNull LazyValueResourceElementWrapper other) {
        return this.myResourceInfo.compareTo(other.myResourceInfo);
    }
}

