/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.lang.aidl.AidlFileType;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.ModuleSourceAutogenerating;
import org.jetbrains.android.compiler.tools.AndroidIdl;
import org.jetbrains.android.compiler.tools.AndroidRenderscript;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAutogenerator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidAutogenerator");

    private AndroidAutogenerator() {
    }

    private static boolean toRun(@NotNull AndroidAutogeneratorMode mode, @NotNull AndroidFacet facet2, @Nullable ModuleSourceAutogenerating autogenerating, boolean force) {
        if (autogenerating == null || !AndroidAutogenerator.supportsAutogeneration(facet2)) {
            return false;
        }
        if (!force && !facet2.getProperties().ENABLE_SOURCES_AUTOGENERATION) {
            return false;
        }
        switch (mode) {
            case AAPT: 
            case AIDL: 
            case RENDERSCRIPT: 
            case BUILDCONFIG: {
                return true;
            }
        }
        LOG.error("Unknown autogenerator mode " + (Object)((Object)mode));
        return false;
    }

    public static boolean supportsAutogeneration(@NotNull AndroidFacet facet2) {
        return !AndroidModel.isRequired(facet2);
    }

    public static void run(@NotNull AndroidAutogeneratorMode mode, @NotNull AndroidFacet facet2, @NotNull CompileContext context, boolean force) {
        ModuleSourceAutogenerating autogenerating = ModuleSourceAutogenerating.getInstance(facet2);
        if (!AndroidAutogenerator.toRun(mode, facet2, autogenerating, force)) {
            return;
        }
        HashSet<String> obsoleteFiles = new HashSet<String>(autogenerating.getAutogeneratedFiles(mode));
        switch (mode) {
            case AAPT: {
                AndroidAutogenerator.runAapt(facet2, autogenerating, context, force);
                break;
            }
            case AIDL: {
                AndroidAutogenerator.runAidl(facet2, autogenerating, context);
                break;
            }
            case RENDERSCRIPT: {
                AndroidAutogenerator.runRenderscript(facet2, autogenerating, context);
                break;
            }
            case BUILDCONFIG: {
                AndroidAutogenerator.runBuildConfigGenerator(facet2, autogenerating, context);
                break;
            }
            default: {
                LOG.error("Unknown mode" + (Object)((Object)mode));
            }
        }
        obsoleteFiles.removeAll(autogenerating.getAutogeneratedFiles(mode));
        for (String path2 : obsoleteFiles) {
            File file2 = new File(path2);
            if (!file2.isFile()) continue;
            FileUtil.delete((File)file2);
            CompilerUtil.refreshIOFile((File)file2);
        }
    }

    private static void runBuildConfigGenerator(final @NotNull AndroidFacet facet2, @NotNull ModuleSourceAutogenerating autogenerating, final @NotNull CompileContext context) {
        final Module module2 = facet2.getModule();
        BuildconfigAutogenerationItem item = (BuildconfigAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<BuildconfigAutogenerationItem>(){

            @Nullable
            public BuildconfigAutogenerationItem compute() {
                if (module2.isDisposed() || module2.getProject().isDisposed()) {
                    return null;
                }
                String sourceRootPath = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet2);
                if (sourceRootPath == null) {
                    return null;
                }
                VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet2);
                if (manifestFile == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module2.getName()), null, -1, -1);
                    return null;
                }
                Manifest manifest = AndroidUtils.loadDomElement(module2, manifestFile, Manifest.class);
                if (manifest == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, "Cannot parse file", manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String packageName = (String)manifest.getPackage().getValue();
                if (packageName != null) {
                    packageName = packageName.trim();
                }
                if (packageName == null || packageName.length() <= 0) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("package.not.found.error", new Object[0]), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                if (!AndroidUtils.isValidAndroidPackageName(packageName)) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("not.valid.package.name.error", packageName), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                return new BuildconfigAutogenerationItem(packageName, FileUtil.toSystemDependentName((String)sourceRootPath));
            }
        });
        if (item == null) {
            return;
        }
        try {
            AndroidAutogenerator.generateStubClass(item.myPackage, new File(item.mySourceRootOsPath), "BuildConfig", "  public final static boolean DEBUG = Boolean.parseBoolean(null);\n");
            VirtualFile genSourceRoot = LocalFileSystem.getInstance().findFileByPath(item.mySourceRootOsPath);
            if (genSourceRoot != null) {
                genSourceRoot.refresh(false, true);
            }
            autogenerating.clearAutogeneratedFiles(AndroidAutogeneratorMode.BUILDCONFIG);
            VirtualFile genFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(item.mySourceRootOsPath + '/' + item.myPackage.replace('.', '/') + '/' + "BuildConfig.java");
            if (genFile != null && genFile.exists()) {
                autogenerating.markFileAutogenerated(AndroidAutogeneratorMode.BUILDCONFIG, genFile);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module2.getProject().isDisposed()) {
                        return;
                    }
                    context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAapt(final @NotNull AndroidFacet facet2, @NotNull ModuleSourceAutogenerating autogenerating, final @NotNull CompileContext context, boolean force) {
        VirtualFile genFile;
        final Module module2 = facet2.getModule();
        AptAutogenerationItem item = (AptAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AptAutogenerationItem>(){

            @Nullable
            public AptAutogenerationItem compute() {
                if (module2.isDisposed() || module2.getProject().isDisposed()) {
                    return null;
                }
                VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet2);
                if (manifestFile == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module2.getName()), null, -1, -1);
                    return null;
                }
                Manifest manifest = AndroidUtils.loadDomElement(module2, manifestFile, Manifest.class);
                if (manifest == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, "Cannot parse file", manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String packageName = (String)manifest.getPackage().getValue();
                if (packageName != null) {
                    packageName = packageName.trim();
                }
                if (packageName == null || packageName.length() <= 0) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("package.not.found.error", new Object[0]), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                if (!AndroidUtils.isValidAndroidPackageName(packageName)) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("not.valid.package.name.error", packageName), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String sourceRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet2);
                if (sourceRootPath == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.apt.gen.not.specified", module2.getName()), null, -1, -1);
                    return null;
                }
                HashMap<String, String> genFilePath2Package = new HashMap<String, String>();
                String packageDir = packageName.replace('.', '/') + '/';
                genFilePath2Package.put(packageDir + "Manifest.java", packageName);
                genFilePath2Package.put(packageDir + "R.java", packageName);
                return new AptAutogenerationItem(packageName, sourceRootPath, genFilePath2Package);
            }
        });
        if (item == null) {
            return;
        }
        if (force) {
            HashSet<VirtualFile> filesToCheck = new HashSet<VirtualFile>();
            for (String string : item.myGenFileRelPath2package.keySet()) {
                String genFileFullPath = item.myOutputDirOsPath + '/' + string;
                if (!new File(genFileFullPath).exists() || (genFile = LocalFileSystem.getInstance().findFileByPath(genFileFullPath)) == null) continue;
                filesToCheck.add(genFile);
            }
            if (!AndroidAutogenerator.ensureFilesWritable(module2.getProject(), filesToCheck)) {
                return;
            }
        }
        File tempOutDir = null;
        try {
            tempOutDir = FileUtil.createTempDirectory((String)"android_apt_autogeneration", (String)"tmp");
            AndroidAutogenerator.generateStubClasses(item.myPackage, tempOutDir, "R", "Manifest");
            for (String string : item.myGenFileRelPath2package.keySet()) {
                File srcFile = new File(tempOutDir.getPath() + '/' + string);
                if (!srcFile.isFile()) continue;
                final File dstFile = new File(item.myOutputDirOsPath + '/' + string);
                if (dstFile.exists()) {
                    if (!force) continue;
                    if (!FileUtil.delete((File)dstFile)) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                if (module2.isDisposed() || module2.getProject().isDisposed()) {
                                    return;
                                }
                                context.addMessage(CompilerMessageCategory.ERROR, "Cannot delete " + FileUtil.toSystemDependentName((String)dstFile.getPath()), null, -1, -1);
                            }
                        });
                    }
                }
                FileUtil.rename((File)srcFile, (File)dstFile);
            }
            for (Map.Entry entry : item.myGenFileRelPath2package.entrySet()) {
                String path2 = item.myOutputDirOsPath + '/' + (String)entry.getKey();
                String aPackage = (String)entry.getValue();
                File file2 = new File(path2);
                CompilerUtil.refreshIOFile((File)file2);
                AndroidAutogenerator.removeAllFilesWithSameName(module2, file2, item.myOutputDirOsPath);
                AndroidAutogenerator.removeDuplicateClasses(module2, aPackage, file2, item.myOutputDirOsPath);
            }
            VirtualFile genSourceRoot = LocalFileSystem.getInstance().findFileByPath(item.myOutputDirOsPath);
            if (genSourceRoot != null) {
                genSourceRoot.refresh(false, true);
            }
            autogenerating.clearAutogeneratedFiles(AndroidAutogeneratorMode.AAPT);
            for (String relPath : item.myGenFileRelPath2package.keySet()) {
                genFile = LocalFileSystem.getInstance().findFileByPath(item.myOutputDirOsPath + '/' + relPath);
                if (genFile == null || !genFile.exists()) continue;
                autogenerating.markFileAutogenerated(AndroidAutogeneratorMode.AAPT, genFile);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module2.getProject().isDisposed()) {
                        return;
                    }
                    context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                }
            });
        }
        finally {
            if (tempOutDir != null) {
                FileUtil.delete((File)tempOutDir);
            }
        }
    }

    private static void generateStubClasses(@NotNull String aPackage, @NotNull File outputDir, String ... classNames) throws IOException {
        assert (!aPackage.isEmpty());
        for (String className2 : classNames) {
            AndroidAutogenerator.generateStubClass(aPackage, outputDir, className2, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateStubClass(String aPackage, File outputDir, String className2, String content2) throws IOException {
        File packageDir = new File(outputDir.getPath() + '/' + aPackage.replace('.', '/'));
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            throw new IOException("Cannot create directory " + FileUtil.toSystemDependentName((String)packageDir.getPath()));
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(packageDir, className2 + ".java")));){
            writer.write("/*___Generated_by_IDEA___*/\n\npackage " + aPackage + ";\n\n/* This stub is only used by the IDE. It is NOT the " + className2 + " class actually packed into the APK */\npublic final class " + className2 + " {\n" + content2 + "}");
        }
    }

    private static void patchAndMarkGeneratedFile(@NotNull AndroidFacet facet2, @NotNull ModuleSourceAutogenerating autogenerating, @NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile vFile) throws IOException {
        File file2 = new File(vFile.getPath());
        String fileText = FileUtil.loadFile((File)file2);
        FileUtil.writeToFile((File)file2, (String)("/*___Generated_by_IDEA___*/\n\n" + fileText));
        autogenerating.markFileAutogenerated(mode, vFile);
    }

    private static void removeAllFilesWithSameName(final @NotNull Module module2, final @NotNull File file2, @NotNull String directoryPath) {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file2);
        VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(directoryPath);
        if (vFile == null || genDir == null) {
            return;
        }
        Collection files2 = (Collection)DumbService.getInstance((Project)module2.getProject()).runReadActionInSmartMode((Computable)new Computable<Collection<VirtualFile>>(){

            @Nullable
            public Collection<VirtualFile> compute() {
                if (module2.isDisposed() || module2.getProject().isDisposed()) {
                    return null;
                }
                return FilenameIndex.getVirtualFilesByName((Project)module2.getProject(), (String)file2.getName(), (GlobalSearchScope)module2.getModuleScope(false));
            }
        });
        if (files2 == null) {
            return;
        }
        final ArrayList<VirtualFile> filesToDelete = new ArrayList<VirtualFile>();
        for (VirtualFile f : files2) {
            if (Objects.equals(f, vFile) || !VfsUtilCore.isAncestor((VirtualFile)genDir, (VirtualFile)f, (boolean)true)) continue;
            filesToDelete.add(f);
        }
        if (filesToDelete.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        for (VirtualFile f : filesToDelete) {
                            if (!f.isValid() || !f.exists()) continue;
                            try {
                                f.delete((Object)module2.getProject());
                            }
                            catch (IOException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                    }
                });
            }
        });
    }

    private static void runAidl(final @NotNull AndroidFacet facet2, @NotNull ModuleSourceAutogenerating autogenerating, final @NotNull CompileContext context) {
        final Module module2 = facet2.getModule();
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(module2, false);
        VirtualFile[] files2 = moduleCompileScope.getFiles((FileType)AidlFileType.INSTANCE, true);
        ArrayList<IdlAutogenerationItem> items2 = new ArrayList<IdlAutogenerationItem>();
        for (final VirtualFile file2 : files2) {
            IdlAutogenerationItem item = (IdlAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<IdlAutogenerationItem>(){

                @Nullable
                public IdlAutogenerationItem compute() {
                    IAndroidTarget target;
                    if (module2.isDisposed() || module2.getProject().isDisposed()) {
                        return null;
                    }
                    AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet2.getModule());
                    IAndroidTarget iAndroidTarget = target = androidPlatform == null ? null : androidPlatform.getTarget();
                    if (target == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module2.getName()), null, -1, -1);
                        return null;
                    }
                    String packageName = AndroidUtils.computePackageName(module2, file2);
                    if (packageName == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot compute package for file", file2.getUrl(), -1, -1);
                        return null;
                    }
                    String sourceRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet2);
                    if (sourceRootPath == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.apt.gen.not.specified", module2.getName()), null, -1, -1);
                        return null;
                    }
                    VirtualFile[] sourceRoots = AndroidAutogenerator.getSourceRootsForModuleAndDependencies(module2, false);
                    String[] sourceRootOsPaths = AndroidCompileUtil.toOsPaths(sourceRoots);
                    String outFileOsPath = FileUtil.toSystemDependentName((String)(sourceRootPath + '/' + packageName.replace('.', '/') + '/' + file2.getNameWithoutExtension() + ".java"));
                    return new IdlAutogenerationItem(file2, target, outFileOsPath, sourceRootOsPaths, sourceRootPath, packageName);
                }
            });
            if (item == null) continue;
            items2.add(item);
        }
        HashSet<VirtualFile> filesToCheck = new HashSet<VirtualFile>();
        for (IdlAutogenerationItem item : items2) {
            if (!new File(FileUtil.toSystemDependentName((String)item.myFile.getPath())).exists()) continue;
            filesToCheck.add(item.myFile);
        }
        if (!AndroidAutogenerator.ensureFilesWritable(module2.getProject(), filesToCheck)) {
            return;
        }
        autogenerating.clearAutogeneratedFiles(AndroidAutogeneratorMode.AIDL);
        for (IdlAutogenerationItem item : items2) {
            VirtualFile file2;
            file2 = item.myFile;
            String fileOsPath = FileUtil.toSystemDependentName((String)file2.getPath());
            try {
                VirtualFile outFile;
                final Map messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidIdl.execute((IAndroidTarget)item.myTarget, (String)fileOsPath, (String)item.myOutFileOsPath, (String[])item.mySourceRootOsPaths));
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module2.getProject().isDisposed()) {
                            return;
                        }
                        for (CompilerMessageCategory category : messages.keySet()) {
                            List messageList = (List)messages.get(category);
                            for (String message2 : messageList) {
                                context.addMessage(category, message2, file2.getUrl(), -1, -1);
                            }
                        }
                    }
                });
                AndroidAutogenerator.removeDuplicateClasses(module2, item.myPackage, new File(item.myOutFileOsPath), item.myOutDirOsPath);
                VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(item.myOutDirOsPath);
                if (genDir != null) {
                    genDir.refresh(false, true);
                }
                if ((outFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(item.myOutFileOsPath)) == null || !outFile.exists()) continue;
                AndroidAutogenerator.patchAndMarkGeneratedFile(facet2, autogenerating, AndroidAutogeneratorMode.AIDL, outFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module2.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), file2.getUrl(), -1, -1);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runRenderscript(final @NotNull AndroidFacet facet2, @NotNull ModuleSourceAutogenerating autogenerating, final @NotNull CompileContext context) {
        final Module module2 = facet2.getModule();
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(module2, false);
        VirtualFile[] files2 = moduleCompileScope.getFiles((FileType)AndroidRenderscriptFileType.INSTANCE, true);
        autogenerating.clearAutogeneratedFiles(AndroidAutogeneratorMode.RENDERSCRIPT);
        for (final VirtualFile file2 : files2) {
            RenderscriptAutogenerationItem item = (RenderscriptAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderscriptAutogenerationItem>(){

                @Nullable
                public RenderscriptAutogenerationItem compute() {
                    AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
                    if (platform == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module2.getName()), null, -1, -1);
                        return null;
                    }
                    IAndroidTarget target = platform.getTarget();
                    String sdkLocation = platform.getSdkData().getPath();
                    String packageName = AndroidUtils.computePackageName(module2, file2);
                    if (packageName == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot compute package for file", file2.getUrl(), -1, -1);
                        return null;
                    }
                    String resourceDirPath = AndroidRootUtil.getResourceDirPath(facet2);
                    assert (resourceDirPath != null);
                    String sourceRootPath = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet2);
                    if (sourceRootPath == null) {
                        return null;
                    }
                    String rawDirPath = resourceDirPath + '/' + "raw";
                    return new RenderscriptAutogenerationItem(sdkLocation, target, sourceRootPath, rawDirPath);
                }
            });
            if (item == null) continue;
            File tempOutDir = null;
            try {
                tempOutDir = FileUtil.createTempDirectory((String)"android_renderscript_autogeneration", (String)"tmp");
                VirtualFile vTempOutDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempOutDir);
                String depFolderPath = vTempOutDir != null ? AndroidAutogenerator.getDependencyFolder(context.getProject(), file2, vTempOutDir) : null;
                final Map messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidRenderscript.execute((String)item.mySdkLocation, (IAndroidTarget)item.myTarget, (String)file2.getPath(), (String)tempOutDir.getPath(), (String)depFolderPath, (String)item.myRawDirPath));
                if (((List)messages.get(CompilerMessageCategory.ERROR)).isEmpty()) {
                    ArrayList newFiles = new ArrayList();
                    AndroidBuildCommonUtils.moveAllFiles((File)tempOutDir, (File)new File(item.myGenDirPath), newFiles);
                    for (File newFile : newFiles) {
                        VirtualFile newVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(newFile);
                        if (newVFile == null) continue;
                        AndroidAutogenerator.patchAndMarkGeneratedFile(facet2, autogenerating, AndroidAutogeneratorMode.RENDERSCRIPT, newVFile);
                    }
                    File bcFile = new File(item.myRawDirPath, FileUtil.getNameWithoutExtension((String)file2.getName()) + ".bc");
                    VirtualFile vBcFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(bcFile);
                    if (vBcFile != null) {
                        autogenerating.markFileAutogenerated(AndroidAutogeneratorMode.RENDERSCRIPT, vBcFile);
                    }
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module2.getProject().isDisposed()) {
                            return;
                        }
                        for (CompilerMessageCategory category : messages.keySet()) {
                            List messageList = (List)messages.get(category);
                            for (String message2 : messageList) {
                                context.addMessage(category, message2, file2.getUrl(), -1, -1);
                            }
                        }
                    }
                });
                VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(item.myGenDirPath);
                if (genDir == null) continue;
                genDir.refresh(false, true);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module2.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), file2.getUrl(), -1, -1);
                    }
                });
            }
            finally {
                if (tempOutDir != null) {
                    FileUtil.delete((File)tempOutDir);
                }
            }
        }
    }

    private static boolean ensureFilesWritable(final @NotNull Project project, final @NotNull Collection<VirtualFile> filesToCheck) {
        if (filesToCheck.isEmpty()) {
            return true;
        }
        final boolean[] run2 = new boolean[]{false};
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                run2[0] = !project.isDisposed() && ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])filesToCheck.toArray(VirtualFile.EMPTY_ARRAY));
            }
        });
        return run2[0];
    }

    private static void removeDuplicateClasses(final @NotNull Module module2, final @NotNull String aPackage, final @NotNull File generatedFile, final @NotNull String sourceRootPath) {
        if (generatedFile.exists()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module2.getProject().isDisposed() || module2.isDisposed()) {
                        return;
                    }
                    String className2 = FileUtil.getNameWithoutExtension((File)generatedFile);
                    AndroidCompileUtil.removeDuplicatingClasses(module2, aPackage, className2, generatedFile, sourceRootPath);
                }
            });
        }
    }

    private static void fillSourceRoots(@NotNull Module module2, @NotNull Set<Module> visited, @NotNull Set<VirtualFile> result2, boolean includingTests) {
        visited.add(module2);
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        VirtualFile resDir = facet2 != null ? AndroidRootUtil.getResourceDir(facet2) : null;
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module2);
        for (VirtualFile virtualFile : manager.getSourceRoots(includingTests)) {
            if (Objects.equals(resDir, virtualFile)) continue;
            result2.add(virtualFile);
        }
        for (VirtualFile virtualFile : manager.getOrderEntries()) {
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            DependencyScope scope2;
            if (!(virtualFile instanceof ModuleOrderEntry) || (scope2 = (moduleOrderEntry = (ModuleOrderEntry)virtualFile).getScope()) != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || visited.contains(depModule)) continue;
            AndroidAutogenerator.fillSourceRoots(depModule, visited, result2, false);
        }
    }

    @NotNull
    public static VirtualFile[] getSourceRootsForModuleAndDependencies(@NotNull Module module2, boolean includingTests) {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        AndroidAutogenerator.fillSourceRoots(module2, new HashSet<Module>(), result2, includingTests);
        return VfsUtil.toVirtualFileArray(result2);
    }

    @Nullable
    static String getDependencyFolder(@NotNull Project project, @NotNull VirtualFile sourceFile, @NotNull VirtualFile genFolder) {
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = index2.getSourceRootForFile(sourceFile);
        if (sourceRoot == null) {
            return null;
        }
        VirtualFile parent = sourceFile.getParent();
        if (Objects.equals(parent, sourceRoot)) {
            return genFolder.getPath();
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)sourceFile.getParent(), (VirtualFile)sourceRoot, (char)'/');
        assert (relativePath != null);
        return genFolder.getPath() + '/' + relativePath;
    }

    private static class BuildconfigAutogenerationItem {
        final String myPackage;
        final String mySourceRootOsPath;

        private BuildconfigAutogenerationItem(@NotNull String aPackage, @NotNull String sourceRootOsPath) {
            this.myPackage = aPackage;
            this.mySourceRootOsPath = sourceRootOsPath;
        }
    }

    private static class RenderscriptAutogenerationItem {
        final String mySdkLocation;
        final IAndroidTarget myTarget;
        final String myGenDirPath;
        final String myRawDirPath;

        private RenderscriptAutogenerationItem(@NotNull String sdkLocation, @NotNull IAndroidTarget target, @NotNull String genDirPath, @NotNull String rawDirPath) {
            this.mySdkLocation = sdkLocation;
            this.myTarget = target;
            this.myGenDirPath = genDirPath;
            this.myRawDirPath = rawDirPath;
        }
    }

    private static class IdlAutogenerationItem {
        final VirtualFile myFile;
        final IAndroidTarget myTarget;
        final String myOutFileOsPath;
        final String[] mySourceRootOsPaths;
        final String myOutDirOsPath;
        final String myPackage;

        private IdlAutogenerationItem(@NotNull VirtualFile file2, @NotNull IAndroidTarget target, @NotNull String outFileOsPath, @NotNull String[] sourceRootOsPaths, @NotNull String outDirOsPath, @NotNull String aPackage) {
            this.myFile = file2;
            this.myTarget = target;
            this.myOutFileOsPath = outFileOsPath;
            this.mySourceRootOsPaths = sourceRootOsPaths;
            this.myOutDirOsPath = outDirOsPath;
            this.myPackage = aPackage;
        }
    }

    private static class AptAutogenerationItem {
        final String myPackage;
        final String myOutputDirOsPath;
        final Map<String, String> myGenFileRelPath2package;

        private AptAutogenerationItem(@NotNull String aPackage, @NotNull String outputDirOsPath, @NotNull Map<String, String> genFileRelPath2package) {
            this.myPackage = aPackage;
            this.myOutputDirOsPath = outputDirOsPath;
            this.myGenFileRelPath2package = genFileRelPath2package;
        }
    }
}

