/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidConnectDebuggerAction
extends AnAction {
    private final boolean isAndroidStudio = IdeInfo.getInstance().isAndroidStudio();

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        AndroidProcessChooserDialog dialog2 = new AndroidProcessChooserDialog(project, true);
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            Client client = dialog2.getClient();
            if (client == null) {
                return;
            }
            AppExecutorUtil.getAppExecutorService().execute(() -> AndroidConnectDebuggerAction.closeOldSessionAndRun(project, dialog2.getSelectedAndroidDebugger(), client, dialog2.getRunConfiguration()));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean isVisible = this.isAndroidStudio || project != null && ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID);
        e.getPresentation().setVisible(isVisible);
    }

    @Slow
    public static void closeOldSessionAndRun(@NotNull Project project, @NotNull AndroidDebugger androidDebugger, @NotNull Client client, @Nullable RunConfiguration configuration) {
        AndroidConnectDebuggerAction.terminateRunSessions(project, client);
        androidDebugger.attachToClient(project, client, configuration);
    }

    private static void terminateRunSessions(@NotNull Project project, @NotNull Client selectedClient) {
        int pid = selectedClient.getClientData().getPid();
        for (ProcessHandler handler2 : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            Client client;
            if (!(handler2 instanceof AndroidProcessHandler) || (client = ((AndroidProcessHandler)handler2).getClient(selectedClient.getDevice())) == null || client.getClientData().getPid() != pid) continue;
            handler2.notifyTextAvailable("Disconnecting run session: a new debug session will be established.\n", ProcessOutputTypes.STDOUT);
            handler2.detachProcess();
            break;
        }
    }
}

