/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.annotations.concurrency.AnyThread;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUsagesTargetProvider
implements UsageTargetProvider {
    @AnyThread
    public UsageTarget[] getTargets(@NotNull Editor editor2, @NotNull PsiFile file2) {
        UsageTarget[] usageTargetArray;
        if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) {
            PsiElement contextElement = file2.findElementAt(editor2.getCaretModel().getOffset());
            if (contextElement == null) {
                return UsageTarget.EMPTY_ARRAY;
            }
            PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)editor2, (int)1);
            ResourceReferencePsiElement resourceReferencePsiElement = null;
            if (targetElement != null) {
                resourceReferencePsiElement = ResourceReferencePsiElement.create(targetElement);
            }
            if (resourceReferencePsiElement == null) {
                resourceReferencePsiElement = IdeResourcesUtil.getResourceElementFromSurroundingValuesTag(contextElement);
            }
            if (resourceReferencePsiElement == null) {
                return UsageTarget.EMPTY_ARRAY;
            }
            resourceReferencePsiElement.putCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT, contextElement);
            return new UsageTarget[]{new PsiElement2UsageTargetAdapter((PsiElement)resourceReferencePsiElement)};
        }
        XmlTag tag = AndroidUsagesTargetProvider.findValueResourceTagInContext(editor2, file2, false);
        if (tag != null) {
            UsageTarget[] usageTargetArray2 = new UsageTarget[1];
            usageTargetArray = usageTargetArray2;
            usageTargetArray2[0] = new PsiElement2UsageTargetAdapter((PsiElement)tag);
        } else {
            usageTargetArray = UsageTarget.EMPTY_ARRAY;
        }
        return usageTargetArray;
    }

    @AnyThread
    @Nullable
    public UsageTarget[] getTargets(@NotNull PsiElement psiElement) {
        if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) {
            if (psiElement instanceof ResourceReferencePsiElement) {
                return UsageTarget.EMPTY_ARRAY;
            }
            ResourceReferencePsiElement referencePsiElement = ResourceReferencePsiElement.create(psiElement);
            if (referencePsiElement == null) {
                return UsageTarget.EMPTY_ARRAY;
            }
            referencePsiElement.putCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT, psiElement);
            return new UsageTarget[]{new PsiElement2UsageTargetAdapter((PsiElement)referencePsiElement)};
        }
        return UsageTarget.EMPTY_ARRAY;
    }

    @Nullable
    public static XmlTag findValueResourceTagInContext(@NotNull Editor editor2, @NotNull PsiFile file2, boolean rename) {
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return null;
        }
        if (!IdeResourcesUtil.isInResourceSubdirectory(file2, ResourceFolderType.VALUES.getName())) {
            return null;
        }
        PsiElement element2 = file2.findElementAt(editor2.getCaretModel().getOffset());
        if (!rename && element2 instanceof XmlToken && XmlTokenType.XML_DATA_CHARACTERS.equals(((XmlToken)element2).getTokenType())) {
            return null;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
        if (element2 instanceof XmlToken && XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN.equals(((XmlToken)element2).getTokenType()) && tag != null) {
            String parentValue;
            XmlAttribute parentAttribute = tag.getAttribute("parent");
            String string = parentValue = parentAttribute != null ? parentAttribute.getValue() : null;
            if (parentValue != null && parentValue.equals(element2.getText())) {
                return null;
            }
        }
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
        if (tag != null && parentTag != null && "item".equals(tag.getName()) && "style".equals(parentTag.getName()) && !rename) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)file2).getRootTag();
        if (rootTag == null || !"resources".equals(rootTag.getName())) {
            return null;
        }
        return tag;
    }
}

