/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardStepWithDescription
extends DynamicWizardStep
implements Disposable {
    protected static final ScopedStateStore.Key<String> KEY_DESCRIPTION = ScopedStateStore.createKey(DynamicWizardStepWithDescription.class + ".description", ScopedStateStore.Scope.STEP, String.class);
    private static final String PROPERTY_FOCUS_OWNER = "focusOwner";
    @Nullable
    private final Disposable myDisposable;
    private PropertyChangeListener myFocusListener;
    private JPanel myRootPane;
    private JLabel myDescriptionLabel;
    private JBLabel myErrorWarningLabel;
    private JPanel mySouthPanel;
    private Map<Component, String> myControlDescriptions;

    public DynamicWizardStepWithDescription(@Nullable Disposable parentDisposable) {
        this.$$$setupUI$$$();
        this.myControlDescriptions = new WeakHashMap<Component, String>();
        this.myDisposable = parentDisposable;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
        this.mySouthPanel.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        this.myErrorWarningLabel.setForeground((Color)JBColor.red);
        this.myDescriptionLabel.setText(" ");
    }

    protected static CompoundBorder createBodyBorder() {
        int fontSize = UIUtil.getLabelFont().getSize();
        Border insetBorder = BorderFactory.createEmptyBorder(fontSize * 4, fontSize * 2, fontSize * 4, fontSize * 2);
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(JBColor.border()), insetBorder);
    }

    @Override
    @NotNull
    protected JPanel createStepBody() {
        return this.myRootPane;
    }

    protected void setControlDescription(Component control, @Nullable String description2) {
        if (this.myFocusListener == null) {
            this.myFocusListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() instanceof Component) {
                        DynamicWizardStepWithDescription.this.updateDescription((Component)evt.getNewValue());
                    }
                }
            };
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(PROPERTY_FOCUS_OWNER, this.myFocusListener);
        }
        if (StringUtil.isEmpty((String)description2)) {
            this.myControlDescriptions.remove(control);
        } else {
            this.myControlDescriptions.put(control, description2);
        }
    }

    private String getDescriptionText(Component component) {
        while (component != null && !this.myControlDescriptions.containsKey(component)) {
            component = component.getParent();
        }
        return component != null ? this.myControlDescriptions.get(component) : "";
    }

    private void updateDescription(Component focusedComponent) {
        this.myState.put(KEY_DESCRIPTION, this.getDescriptionText(focusedComponent));
    }

    public void dispose() {
        if (this.myFocusListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(PROPERTY_FOCUS_OWNER, this.myFocusListener);
        }
    }

    protected final void setBodyComponent(JComponent component) {
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)component);
        component.setBorder(new EmptyBorder(new Insets(WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE)));
        this.myRootPane.add((Component)component, "Center");
    }

    @Override
    public void init() {
        this.register(KEY_DESCRIPTION, this.getDescriptionLabel(), new ScopedDataBinder.ComponentBinding<String, JLabel>(){

            @Override
            public void setValue(String newValue, @NotNull JLabel label) {
                label.setText(DynamicWizardStepWithDescription.this.toHtml(newValue));
            }
        });
    }

    protected JLabel getDescriptionLabel() {
        return this.myDescriptionLabel;
    }

    @NotNull
    public final JBLabel getMessageLabel() {
        return this.myErrorWarningLabel;
    }

    @Nullable
    protected Disposable getDisposable() {
        return this.myDisposable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPane = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "South");
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myErrorWarningLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPane;
    }
}

