/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.tools.idea.whatsnew.assistant.WhatsNewBundleCreator;
import com.intellij.openapi.application.PathManager;
import com.intellij.util.PathUtil;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/whatsnew/assistant/WhatsNewURLProvider;", "", "()V", "getConfigCacheDir", "Ljava/nio/file/Path;", "getLocalConfig", "version", "", "getResourceFileAsStream", "Ljava/io/InputStream;", "bundleCreator", "Lcom/android/tools/idea/whatsnew/assistant/WhatsNewBundleCreator;", "getWebConfig", "Ljava/net/URL;", "whats-new-assistant"})
public class WhatsNewURLProvider {
    @NotNull
    public URL getWebConfig(@NotNull String version2) {
        URL uRL;
        try {
            uRL = new URL("https://developer.android.com/studio/releases/assistant/" + version2 + ".xml");
        }
        catch (MalformedURLException e) {
            throw (Throwable)new RuntimeException("Could not get path for web WNA xml file");
        }
        return uRL;
    }

    @NotNull
    public Path getLocalConfig(@NotNull String version2) {
        return this.getConfigCacheDir().resolve(version2 + ".xml");
    }

    @Nullable
    public InputStream getResourceFileAsStream(@Nullable WhatsNewBundleCreator bundleCreator, @NotNull String version2) {
        Object object = bundleCreator;
        return object != null && (object = object.getClass()) != null ? ((Class)object).getResourceAsStream("/whats-new-assistant.xml") : null;
    }

    private final Path getConfigCacheDir() {
        Path path2 = Paths.get(PathUtil.getCanonicalPath((String)PathManager.getSystemPath()), "whatsnew");
        path2.toFile().mkdirs();
        return path2;
    }
}

