/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.OpenAssistSidePanelAction;
import com.android.tools.idea.whatsnew.assistant.WhatsNewBundleCreator;
import com.android.tools.idea.whatsnew.assistant.WhatsNewMetricsTracker;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.WhatsNewAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class WhatsNewSidePanelAction
extends OpenAssistSidePanelAction {
    @NotNull
    private static WhatsNewAction action = new WhatsNewAction();
    @NotNull
    private final Map<Project, WhatsNewToolWindowListener> myProjectToListenerMap = new HashMap<Project, WhatsNewToolWindowListener>();

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (e.getProject() == null) {
            presentation.setEnabled(false);
        } else if (!presentation.isEnabled()) {
            presentation.setEnabled(true);
        }
        action.update(e);
        presentation.setDescription(AndroidBundle.message("whatsnew.action.custom.description", ApplicationNamesInfo.getInstance().getFullProductName()));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        this.openWhatsNewSidePanel(Objects.requireNonNull(event.getProject()), false);
    }

    public void openWhatsNewSidePanel(@NotNull Project project, boolean isAutoOpened) {
        WhatsNewBundleCreator bundleCreator = (WhatsNewBundleCreator)AssistantBundleCreator.EP_NAME.findExtension(WhatsNewBundleCreator.class);
        if (bundleCreator == null || !bundleCreator.shouldShowWhatsNew()) {
            BrowserUtil.browse((String)ApplicationInfoEx.getInstanceEx().getWhatsNewUrl());
            return;
        }
        WhatsNewToolWindowListener.fireOpenEvent(project, isAutoOpened);
        this.openWindow("DeveloperServices.WhatsNewAssistant", project);
        this.myProjectToListenerMap.computeIfAbsent(project, this::newWhatsNewToolWindowListener);
    }

    @NotNull
    private WhatsNewToolWindowListener newWhatsNewToolWindowListener(@NotNull Project project) {
        WhatsNewToolWindowListener listener2 = new WhatsNewToolWindowListener(project, this.myProjectToListenerMap);
        project.getMessageBus().connect((Disposable)project).subscribe(ToolWindowManagerListener.TOPIC, (Object)listener2);
        return listener2;
    }

    static class WhatsNewToolWindowListener
    implements ToolWindowManagerListener {
        @NotNull
        private Project myProject;
        @NotNull
        Map<Project, WhatsNewToolWindowListener> myProjectToListenerMap;
        private boolean isOpen;

        private WhatsNewToolWindowListener(@NotNull Project project, @NotNull Map<Project, WhatsNewToolWindowListener> projectToListenerMap) {
            this.myProject = project;
            this.myProjectToListenerMap = projectToListenerMap;
            this.isOpen = true;
            project.getMessageBus().connect((Disposable)project).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (!project.equals(myProject)) {
                        return;
                    }
                    if (isOpen) {
                        WhatsNewToolWindowListener.fireClosedEvent(myProject);
                        isOpen = false;
                    }
                    myProjectToListenerMap.remove(project);
                    WhatsNewMetricsTracker.getInstance().clearCachedActionKeys(myProject);
                }
            });
        }

        public void toolWindowRegistered(@NotNull String id) {
        }

        public void toolWindowUnregistered(@NotNull String id, @NotNull ToolWindow toolWindow) {
            if (id.equals("Assistant")) {
                this.myProjectToListenerMap.remove(this.myProject);
                WhatsNewMetricsTracker.getInstance().clearCachedActionKeys(this.myProject);
            }
        }

        public void stateChanged() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    this.myProjectToListenerMap.remove(this.myProject);
                    return;
                }
                ToolWindow window2 = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Assistant");
                if (window2 == null) {
                    return;
                }
                if (!"DeveloperServices.WhatsNewAssistant".equals(window2.getHelpId())) {
                    return;
                }
                if (this.isOpen && !window2.isVisible()) {
                    WhatsNewToolWindowListener.fireClosedEvent(this.myProject);
                    this.isOpen = false;
                } else if (!this.isOpen && window2.isVisible()) {
                    WhatsNewToolWindowListener.fireOpenEvent(this.myProject, false);
                    this.isOpen = true;
                }
            });
        }

        private static void fireOpenEvent(@NotNull Project project, boolean isAutoOpened) {
            WhatsNewMetricsTracker.getInstance().open(project, isAutoOpened);
        }

        private static void fireClosedEvent(@NotNull Project project) {
            WhatsNewMetricsTracker.getInstance().close(project);
        }
    }
}

