/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkMerger;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.ui.ApplicationUtils;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.AndroidSdk;
import com.android.tools.idea.welcome.install.AndroidVirtualDevice;
import com.android.tools.idea.welcome.install.CheckSdkOperation;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.Gvm;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.InstallationIntention;
import com.android.tools.idea.welcome.install.Platform;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizard;
import com.android.tools.idea.welcome.wizard.deprecated.InstallSummaryStep;
import com.android.tools.idea.welcome.wizard.deprecated.LongRunningOperationPath;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.SdkComponentsStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsPath
extends DynamicWizardPath
implements LongRunningOperationPath {
    private final FileOp myFileOp = FileOpUtils.create();
    @NotNull
    private final FirstRunWizardMode myMode;
    private AndroidSdkHandler myLocalHandler;
    private ComponentTreeNode myComponentTree;
    private final ProgressStep myProgressStep;
    @NotNull
    private ComponentInstaller myComponentInstaller;
    private final boolean myInstallUpdates;
    private SdkComponentsStep myComponentsStep;

    public InstallComponentsPath(@NotNull FirstRunWizardMode mode, @NotNull File sdkLocation, @NotNull ProgressStep progressStep, boolean installUpdates) {
        this.myMode = mode;
        this.myLocalHandler = AndroidSdkHandler.getInstance((File)sdkLocation);
        this.myProgressStep = progressStep;
        this.myComponentInstaller = new ComponentInstaller(this.myLocalHandler);
        this.myInstallUpdates = installUpdates;
    }

    private ComponentTreeNode createComponentTree(@NotNull FirstRunWizardMode reason, boolean createAvd) {
        InstallationIntention installationIntention;
        ArrayList components = Lists.newArrayList();
        components.add(new AndroidSdk(this.myInstallUpdates));
        RepoManager sdkManager = this.myLocalHandler.getSdkManager((com.android.repository.api.ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        sdkManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)new StudioProgressRunner(true, false, "Finding Available SDK Components", null), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), true);
        Map remotePackages = sdkManager.getPackages().getRemotePackages();
        ComponentTreeNode platforms = Platform.Companion.createSubtree(remotePackages, this.myInstallUpdates);
        if (platforms != null) {
            components.add(platforms);
        }
        InstallationIntention installationIntention2 = installationIntention = this.myInstallUpdates ? InstallationIntention.INSTALL_WITH_UPDATES : InstallationIntention.INSTALL_WITHOUT_UPDATES;
        if (reason == FirstRunWizardMode.NEW_INSTALL && Haxm.InstallerInfo.canRun()) {
            components.add(new Haxm(installationIntention, FirstRunWizard.KEY_CUSTOM_INSTALL));
        }
        if (reason == FirstRunWizardMode.NEW_INSTALL && Gvm.InstallerInfo.canRun()) {
            components.add(new Gvm(installationIntention, FirstRunWizard.KEY_CUSTOM_INSTALL));
        }
        if (createAvd) {
            components.add(new AndroidVirtualDevice(remotePackages, this.myInstallUpdates, this.myFileOp));
        }
        return new ComponentCategory("Root", "Root node that is not supposed to appear in the UI", components);
    }

    private static File createTempDir() throws WizardException {
        File tempDirectory;
        try {
            tempDirectory = FileUtil.createTempDirectory((String)"AndroidStudio", (String)"FirstRun", (boolean)true);
        }
        catch (IOException e) {
            throw new WizardException("Unable to create temporary folder: " + e.getMessage(), e);
        }
        return tempDirectory;
    }

    @Nullable
    private File getHandoffAndroidSdkSource() {
        File androidSrc = this.myMode.getAndroidSrc();
        if (androidSrc != null) {
            File[] files2 = androidSrc.listFiles();
            if (androidSrc.isDirectory() && files2 != null && files2.length > 0) {
                return androidSrc;
            }
        }
        return null;
    }

    private InstallOperation<File, File> createInitSdkOperation(InstallContext installContext, double progressRatio) {
        File handoffSource = this.getHandoffAndroidSdkSource();
        if (handoffSource != null) {
            return new MergeOperation(handoffSource, installContext, progressRatio);
        }
        return InstallOperation.wrap(installContext, new ReturnValue(), 0.0);
    }

    @Override
    protected void init() {
        File location = this.myLocalHandler.getLocation();
        assert (location != null);
        this.myState.put(WizardConstants.KEY_SDK_INSTALL_LOCATION, location.getAbsolutePath());
        this.myState.put(WizardConstants.KEY_JDK_LOCATION, EmbeddedDistributionPaths.getInstance().getEmbeddedJdkPath().getPath());
        this.myComponentTree = this.createComponentTree(this.myMode, !HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated() && this.myMode.shouldCreateAvd());
        this.myComponentTree.init(this.myProgressStep);
        this.myComponentsStep = new SdkComponentsStep(this.myComponentTree, FirstRunWizard.KEY_CUSTOM_INSTALL, WizardConstants.KEY_SDK_INSTALL_LOCATION, this.myMode, this.myWizard.getDisposable());
        this.addStep(this.myComponentsStep);
        this.myComponentTree.init(this.myProgressStep);
        this.myComponentTree.updateState(this.myLocalHandler);
        for (DynamicWizardStep step2 : this.myComponentTree.createSteps()) {
            this.addStep(step2);
        }
        if (this.myMode != FirstRunWizardMode.INSTALL_HANDOFF) {
            Supplier<Collection> supplier2 = () -> {
                Collection<InstallableComponent> components = this.myComponentTree.getChildrenToInstall();
                try {
                    return this.myComponentInstaller.getPackagesToInstall(components);
                }
                catch (SdkQuickfixUtils.PackageResolutionException e) {
                    Logger.getInstance(InstallComponentsPath.class).warn((Throwable)e);
                    return null;
                }
            };
            this.addStep(new InstallSummaryStep(FirstRunWizard.KEY_CUSTOM_INSTALL, WizardConstants.KEY_SDK_INSTALL_LOCATION, WizardConstants.KEY_JDK_LOCATION, supplier2));
        }
    }

    @Override
    public void deriveValues(Set<? extends ScopedStateStore.Key> modified) {
        String sdkPath;
        super.deriveValues(modified);
        if (modified.contains(WizardConstants.KEY_SDK_INSTALL_LOCATION) && (sdkPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION)) != null) {
            File sdkLocation = new File(sdkPath);
            if (!FileUtil.filesEqual((File)this.myLocalHandler.getLocation(), (File)sdkLocation)) {
                this.myLocalHandler = AndroidSdkHandler.getInstance((File)sdkLocation);
                StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
                this.myComponentsStep.startLoading();
                this.myLocalHandler.getSdkManager((com.android.repository.api.ProgressIndicator)progress).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of(packages -> {
                    this.myComponentInstaller = new ComponentInstaller(this.myLocalHandler);
                    this.myComponentTree.updateState(this.myLocalHandler);
                    this.myComponentsStep.stopLoading();
                }), (List)ImmutableList.of(() -> this.myComponentsStep.loadingError()), (ProgressRunner)new StudioProgressRunner(false, false, "Finding Available SDK Components", this.getProject()), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
            }
        }
    }

    @Override
    @NotNull
    public String getPathName() {
        return "Setup Android Studio Components";
    }

    @Override
    public void runLongOperation() throws WizardException {
        double INIT_SDK_OPERATION_PROGRESS_SHARE = 0.3;
        double INSTALL_COMPONENTS_OPERATION_PROGRESS_SHARE = 0.7;
        InstallContext installContext = new InstallContext(InstallComponentsPath.createTempDir(), this.myProgressStep);
        File destination = this.getDestination();
        InstallOperation<File, File> initialize = this.createInitSdkOperation(installContext, 0.3);
        Collection<InstallableComponent> selectedComponents = this.myComponentTree.getChildrenToInstall();
        CheckSdkOperation checkSdk = new CheckSdkOperation(installContext);
        InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, this.myComponentInstaller, 0.7);
        SetPreference setPreference = new SetPreference(this.myMode.getInstallerTimestamp(), ModalityState.stateForComponent((Component)this.myWizard.getContentPane()));
        if (selectedComponents.isEmpty()) {
            this.myProgressStep.print("Nothing to do!", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        try {
            initialize.then(install).then(setPreference).then(new ConfigureComponents(installContext, selectedComponents, this.myLocalHandler)).then(checkSdk).execute(destination);
        }
        catch (InstallationCancelledException e) {
            installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
            this.myProgressStep.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @Nullable
    public static RemotePackage findLatestPlatform(@Nullable Map<String, RemotePackage> remotePackages) {
        if (remotePackages == null) {
            return null;
        }
        AndroidVersion max = null;
        RemotePackage latest = null;
        for (RemotePackage pkg : remotePackages.values()) {
            DetailsTypes.PlatformDetailsType platformDetails;
            AndroidVersion version2;
            TypeDetails details = pkg.getTypeDetails();
            if (!(details instanceof DetailsTypes.PlatformDetailsType) || (version2 = (platformDetails = (DetailsTypes.PlatformDetailsType)details).getAndroidVersion()).isPreview() || max != null && version2.compareTo(max) <= 0) continue;
            latest = pkg;
            max = version2;
        }
        return latest;
    }

    @NotNull
    private File getDestination() throws WizardException {
        String destinationPath = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
        assert (destinationPath != null);
        File destination = new File(destinationPath);
        if (destination.isFile()) {
            throw new WizardException(String.format("Path %s does not point to a directory", destination));
        }
        return destination;
    }

    @Override
    public boolean performFinishingActions() {
        return true;
    }

    @Override
    public boolean isPathVisible() {
        return true;
    }

    public boolean shouldDownloadingComponentsStepBeShown() {
        String path2 = this.myState.get(WizardConstants.KEY_SDK_INSTALL_LOCATION);
        assert (path2 != null);
        return SdkLocationUtils.isWritable(this.myFileOp, new File(path2));
    }

    private static class ConfigureComponents
    implements Function<File, File> {
        private final InstallContext myInstallContext;
        private final Collection<? extends InstallableComponent> mySelectedComponents;
        private final AndroidSdkHandler mySdkHandler;

        ConfigureComponents(InstallContext installContext, Collection<? extends InstallableComponent> selectedComponents, AndroidSdkHandler sdkHandler) {
            this.myInstallContext = installContext;
            this.mySelectedComponents = selectedComponents;
            this.mySdkHandler = sdkHandler;
        }

        public File apply(@Nullable File input) {
            assert (input != null);
            for (InstallableComponent installableComponent : this.mySelectedComponents) {
                installableComponent.configure(this.myInstallContext, this.mySdkHandler);
            }
            return input;
        }
    }

    private static class SetPreference
    implements Function<File, File> {
        @Nullable
        private final String myInstallerTimestamp;
        @NotNull
        private final ModalityState myModalityState;

        SetPreference(@Nullable String installerTimestamp, @NotNull ModalityState modalityState) {
            this.myInstallerTimestamp = installerTimestamp;
            this.myModalityState = modalityState;
        }

        public File apply(@Nullable File input) {
            assert (input != null);
            ApplicationUtils.invokeWriteActionAndWait(this.myModalityState, () -> {
                IdeSdks.getInstance().setAndroidSdkPath(input, ProjectManager.getInstance().getDefaultProject());
                AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this.myInstallerTimestamp);
            });
            return input;
        }
    }

    private static class ReturnValue
    implements Function<File, File> {
        private ReturnValue() {
        }

        public File apply(@Nullable File input) {
            assert (input != null);
            return input;
        }
    }

    private static class MergeOperation
    extends InstallOperation<File, File> {
        private final File myRepo;
        private final InstallContext myContext;
        private boolean myRepoWasMerged = false;

        MergeOperation(File repo, InstallContext context, double progressRatio) {
            super(context, progressRatio);
            this.myRepo = repo;
            this.myContext = context;
        }

        @Override
        @NotNull
        protected File perform(@NotNull ProgressIndicator indicator, @NotNull File destination) throws WizardException {
            indicator.setText("Installing Android SDK");
            try {
                FileUtil.ensureExists((File)destination);
                if (!FileUtil.filesEqual((File)destination.getCanonicalFile(), (File)this.myRepo.getCanonicalFile())) {
                    SdkMerger.mergeSdks(this.myRepo, destination, indicator);
                    this.myRepoWasMerged = true;
                }
                this.myContext.print(String.format("Android SDK was installed to %1$s\n", destination), ConsoleViewContentType.SYSTEM_OUTPUT);
                File file2 = destination;
                return file2;
            }
            catch (IOException e) {
                throw new WizardException(e.getMessage(), e);
            }
            finally {
                indicator.stop();
            }
        }

        @Override
        public void cleanup(@NotNull File result2) {
            if (this.myRepoWasMerged && this.myRepo.exists()) {
                FileUtil.delete((File)this.myRepo);
            }
        }
    }
}

