/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.config.GlobalInstallerData;
import com.android.tools.idea.welcome.config.InstallerData;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProviderKt;
import com.android.tools.idea.welcome.wizard.StudioFirstRunWelcomeScreen;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardHost;
import com.google.common.util.concurrent.Atomics;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenProvider;", "Lcom/intellij/openapi/wm/WelcomeScreenProvider;", "()V", "createWelcomeScreen", "Lcom/intellij/openapi/wm/WelcomeScreen;", "rootPane", "Ljavax/swing/JRootPane;", "isAvailable", "", "Companion", "ConnectionState", "intellij.android.core"})
public final class AndroidStudioWelcomeScreenProvider
implements WelcomeScreenProvider {
    private static final String SYSTEM_PROPERTY_DISABLE_WIZARD = "disable.android.first.run";
    private static boolean ourWasShown;
    public static final Companion Companion;

    @NotNull
    public WelcomeScreen createWelcomeScreen(@NotNull JRootPane rootPane) {
        AndroidStudioWelcomeScreenProvider.Companion.checkInternetConnection();
        FirstRunWizardMode firstRunWizardMode = Companion.getWizardMode();
        if (firstRunWizardMode == null) {
            Intrinsics.throwNpe();
        }
        FirstRunWizardMode wizardMode = firstRunWizardMode;
        ourWasShown = true;
        return (Boolean)StudioFlags.NPW_FIRST_RUN_WIZARD.get() != false ? (WelcomeScreen)new StudioFirstRunWelcomeScreen(wizardMode) : (WelcomeScreen)new FirstRunWizardHost(wizardMode);
    }

    public boolean isAvailable() {
        boolean isWizardDisabled = GuiTestingService.getInstance().isGuiTestingMode() || Boolean.getBoolean(SYSTEM_PROPERTY_DISABLE_WIZARD);
        return !ourWasShown && !isWizardDisabled && Companion.getWizardMode() != null;
    }

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    @Nullable
    public static final FirstRunWizardMode getWizardMode() {
        return Companion.getWizardMode();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenProvider$ConnectionState;", "", "(Ljava/lang/String;I)V", "OK", "NO_CONNECTION", "intellij.android.core"})
    private static final class ConnectionState
    extends Enum<ConnectionState> {
        public static final /* enum */ ConnectionState OK;
        public static final /* enum */ ConnectionState NO_CONNECTION;
        private static final /* synthetic */ ConnectionState[] $VALUES;

        static {
            ConnectionState[] connectionStateArray = new ConnectionState[2];
            ConnectionState[] connectionStateArray2 = connectionStateArray;
            connectionStateArray[0] = OK = new ConnectionState();
            connectionStateArray[1] = NO_CONNECTION = new ConnectionState();
            $VALUES = connectionStateArray;
        }

        public static ConnectionState[] values() {
            return (ConnectionState[])$VALUES.clone();
        }

        public static ConnectionState valueOf(String string) {
            return Enum.valueOf(ConnectionState.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenProvider$Companion;", "", "()V", "SYSTEM_PROPERTY_DISABLE_WIZARD", "", "ourWasShown", "", "wizardMode", "Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "getWizardMode", "()Lcom/android/tools/idea/welcome/config/FirstRunWizardMode;", "checkInternetConnection", "Lcom/android/tools/idea/welcome/wizard/AndroidStudioWelcomeScreenProvider$ConnectionState;", "isHandoff", "persistentData", "Lcom/android/tools/idea/welcome/config/AndroidFirstRunPersistentData;", "promptToRetryFailedConnection", "promptUserForProxy", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final FirstRunWizardMode getWizardMode() {
            if (((Boolean)StudioFlags.NPW_FIRST_RUN_WIZARD.get()).booleanValue() || ((Boolean)StudioFlags.NPW_FIRST_RUN_SHOW.get()).booleanValue()) {
                return FirstRunWizardMode.NEW_INSTALL;
            }
            AndroidFirstRunPersistentData persistentData = AndroidFirstRunPersistentData.getInstance();
            return Companion.isHandoff(persistentData) ? FirstRunWizardMode.INSTALL_HANDOFF : (!persistentData.isSdkUpToDate() ? FirstRunWizardMode.NEW_INSTALL : (IdeSdks.getInstance().getEligibleAndroidSdks().isEmpty() ? FirstRunWizardMode.MISSING_SDK : null));
        }

        private final boolean isHandoff(AndroidFirstRunPersistentData persistentData) {
            InstallerData installerData = GlobalInstallerData.get();
            if (installerData == null) {
                return false;
            }
            InstallerData data = installerData;
            return (!persistentData.isSdkUpToDate() || !persistentData.isSameTimestamp(data.getTimestamp())) && data.isCurrentVersion();
        }

        private final ConnectionState checkInternetConnection() {
            CommonProxy.isInstalledAssertion();
            ConnectionState result2 = null;
            while (result2 == null) {
                try {
                    HttpURLConnection connection = HttpConfigurable.getInstance().openHttpConnection("http://developer.android.com");
                    connection.connect();
                    connection.disconnect();
                    result2 = ConnectionState.OK;
                }
                catch (IOException e) {
                    result2 = this.promptToRetryFailedConnection();
                }
                catch (RuntimeException e) {
                    result2 = this.promptToRetryFailedConnection();
                }
                catch (Throwable e) {
                    result2 = ConnectionState.NO_CONNECTION;
                    String message2 = "Couldn't check internet connection";
                    if (StringsKt.contains$default((CharSequence)e.toString(), (CharSequence)"crypto", (boolean)false, (int)2, null)) {
                        message2 = message2 + "; check your JDK/JRE installation / consider running on a newer version.";
                    }
                    AndroidStudioWelcomeScreenProviderKt.getLog().warn(message2, e);
                }
            }
            return result2;
        }

        private final ConnectionState promptToRetryFailedConnection() {
            AtomicReference atomicBoolean = Atomics.newReference();
            ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(atomicBoolean){
                final /* synthetic */ AtomicReference $atomicBoolean;

                public final void invoke() {
                    this.$atomicBoolean.set(com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider$Companion.access$promptUserForProxy(AndroidStudioWelcomeScreenProvider.Companion));
                }
                {
                    this.$atomicBoolean = atomicReference;
                    super(0);
                }
            }), (int)1, null);
            return (ConnectionState)((Object)atomicBoolean.get());
        }

        private final ConnectionState promptUserForProxy() {
            ConnectionState connectionState;
            int selection = Messages.showIdeaMessageDialog(null, (String)"Unable to access Android SDK add-on list", (String)"Android Studio First Run", (String[])new String[]{"Setup Proxy", "Cancel"}, (int)1, (Icon)Messages.getErrorIcon(), null);
            if (selection == 0) {
                HttpConfigurable.editConfigurable(null);
                connectionState = null;
            } else {
                connectionState = ConnectionState.NO_CONNECTION;
            }
            return connectionState;
        }

        private Companion() {
        }

        public static final /* synthetic */ ConnectionState access$promptUserForProxy(Companion $this) {
            return $this.promptUserForProxy();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

