/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.tools.idea.uibuilder.visual.ConfigurationSet;
import com.android.tools.idea.uibuilder.visual.CustomConfigurationAttribute;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="VisualizationTool", storages={@Storage(value="visualizationTool.xml")})
public class VisualizationToolSettings
implements PersistentStateComponent<MyState> {
    private static final ConfigurationSet DEFAULT_CONFIGURATION_SET = ConfigurationSet.PIXEL_DEVICES;
    private GlobalState myGlobalState = new GlobalState();

    public static VisualizationToolSettings getInstance() {
        return (VisualizationToolSettings)ServiceManager.getService(VisualizationToolSettings.class);
    }

    @NotNull
    public GlobalState getGlobalState() {
        return this.myGlobalState;
    }

    public MyState getState() {
        MyState state = new MyState();
        state.setState(this.myGlobalState);
        return state;
    }

    public void loadState(@NotNull MyState state) {
        this.myGlobalState = state.getState();
    }

    public static class GlobalState {
        private boolean myFirstTimeOpen = true;
        private boolean myVisible = false;
        private boolean myShowDecoration = false;
        @NotNull
        private String myConfigurationSetName = ConfigurationSet.PIXEL_DEVICES.name();
        @NotNull
        private List<CustomConfigurationAttribute> myCustomConfigurationAttributes = new ArrayList<CustomConfigurationAttribute>();

        public boolean isFirstTimeOpen() {
            return this.myFirstTimeOpen;
        }

        public void setFirstTimeOpen(boolean firstTimeOpen) {
            this.myFirstTimeOpen = firstTimeOpen;
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        public void setVisible(boolean visible) {
            this.myVisible = visible;
        }

        public boolean getShowDecoration() {
            return this.myShowDecoration;
        }

        public void setShowDecoration(boolean showDecoration) {
            this.myShowDecoration = showDecoration;
        }

        @NotNull
        public String getConfigurationSetName() {
            return this.myConfigurationSetName;
        }

        public void setConfigurationSetName(@NotNull String configurationSetName) {
            this.myConfigurationSetName = configurationSetName;
        }

        @NotNull
        public List<CustomConfigurationAttribute> getCustomConfigurationAttributes() {
            return this.myCustomConfigurationAttributes;
        }

        public void setCustomConfigurationAttributes(@NotNull List<CustomConfigurationAttribute> configurationStrings) {
            this.myCustomConfigurationAttributes = configurationStrings;
        }

        @Transient
        @NotNull
        public ConfigurationSet getConfigurationSet() {
            try {
                ConfigurationSet set = ConfigurationSet.valueOf(this.myConfigurationSetName);
                if (!set.getVisible()) {
                    set = DEFAULT_CONFIGURATION_SET;
                    this.myConfigurationSetName = DEFAULT_CONFIGURATION_SET.name();
                }
                return set;
            }
            catch (IllegalArgumentException e) {
                this.myConfigurationSetName = DEFAULT_CONFIGURATION_SET.name();
                return DEFAULT_CONFIGURATION_SET;
            }
        }

        @Transient
        public void setConfigurationSet(@NotNull ConfigurationSet configurationSet) {
            this.myConfigurationSetName = configurationSet.name();
        }
    }

    public static class MyState {
        private GlobalState myGlobalState = new GlobalState();

        public GlobalState getState() {
            return this.myGlobalState;
        }

        public void setState(GlobalState state) {
            this.myGlobalState = state;
        }
    }
}

