/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    public static final Map<RenderingHints.Key, Object> HQ_RENDERING_HINTS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    public static final int REQUEST_SCALE_DEBOUNCE_TIME_IN_MS = 300;
    private final ScreenView myScreenView;
    @Nullable
    private BufferedImage myCachedVisibleImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private final ScheduledExecutorService myScheduledExecutorService;
    private final RescaleRunnable myRescaleRunnable = new RescaleRunnable(this::onScaledResultReady);
    @Nullable
    private ScheduledFuture<?> myScheduledFuture;
    private final Rectangle myScreenViewVisibleRect = new Rectangle();
    private final Dimension myScreenViewSize = new Dimension();
    private final Rectangle myCachedScreenViewDisplayRect = new Rectangle();
    private double myLastScale;
    private static final Color CLEAR_BACKGROUND = new Color(255, 255, 255, 0);

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        this(screenView, null);
    }

    @VisibleForTesting
    ScreenViewLayer(@NotNull ScreenView screenView, @Nullable ScheduledExecutorService executor) {
        this.myScreenView = screenView;
        this.myScheduledExecutorService = executor != null ? executor : Executors.newScheduledThreadPool(1);
        this.myLastScale = this.myScreenView.getScale();
        Disposer.register((Disposable)screenView.getSurface(), (Disposable)this);
    }

    @NotNull
    private static BufferedImage getPreviewImage(@NotNull GraphicsConfiguration configuration, @NotNull BufferedImage renderedImage, int screenViewX, int screenViewY, @NotNull Rectangle screenViewVisibleSize, double xScaleFactor, double yScaleFactor, @Nullable BufferedImage existingBuffer, boolean screenViewHasBorderLayer) {
        boolean clearBackground;
        BufferedImage image;
        boolean bufferWithScreenViewSizeExists;
        int sx1 = (int)Math.round((double)(screenViewVisibleSize.x - screenViewX) * xScaleFactor);
        int sy1 = (int)Math.round((double)(screenViewVisibleSize.y - screenViewY) * yScaleFactor);
        int sx2 = sx1 + (int)Math.round((double)screenViewVisibleSize.width * xScaleFactor);
        int sy2 = sy1 + (int)Math.round((double)screenViewVisibleSize.height * yScaleFactor);
        boolean bl = bufferWithScreenViewSizeExists = existingBuffer != null && existingBuffer.getWidth() == screenViewVisibleSize.width && existingBuffer.getHeight() == screenViewVisibleSize.height;
        if (screenViewHasBorderLayer && bufferWithScreenViewSizeExists) {
            image = existingBuffer instanceof JBHiDPIScaledImage ? (BufferedImage)((JBHiDPIScaledImage)existingBuffer).getDelegate() : existingBuffer;
            clearBackground = true;
        } else {
            image = configuration.createCompatibleImage(screenViewVisibleSize.width, screenViewVisibleSize.height, 3);
            assert (image != null);
            existingBuffer = image;
            clearBackground = false;
        }
        Graphics2D cacheImageGraphics = image.createGraphics();
        cacheImageGraphics.setRenderingHints(HQ_RENDERING_HINTS);
        if (clearBackground) {
            cacheImageGraphics.setColor(CLEAR_BACKGROUND);
            cacheImageGraphics.setComposite(AlphaComposite.Clear);
            cacheImageGraphics.fillRect(0, 0, image.getWidth(), image.getHeight());
            cacheImageGraphics.setComposite(AlphaComposite.Src);
        }
        cacheImageGraphics.drawImage(renderedImage, 0, 0, image.getWidth(), image.getHeight(), sx1, sy1, sx2, sy2, null);
        cacheImageGraphics.dispose();
        return existingBuffer;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D) {
        BufferedImage renderedImage;
        this.myScreenView.getScaledContentSize(this.myScreenViewSize);
        this.myScreenViewVisibleRect.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle clipBounds = graphics2D.getClipBounds();
        if (!this.myScreenViewVisibleRect.intersects((Rectangle2D)clipBounds)) {
            return;
        }
        if ((double)this.myScreenViewVisibleRect.width > ((RectangularShape)clipBounds).getWidth() || (double)this.myScreenViewVisibleRect.height > ((RectangularShape)clipBounds).getHeight()) {
            Rectangle2D.intersect(this.myScreenViewVisibleRect, clipBounds, this.myScreenViewVisibleRect);
        }
        BufferedImage previousVisibleImage = this.myCachedVisibleImage;
        RenderResult renderResult = this.myScreenView.getResult();
        boolean drawNewImg = false;
        if (this.newRenderImageAvailable(renderResult)) {
            this.setLastRenderResult(renderResult);
            this.myScreenView.getScene().needsRebuildList();
            drawNewImg = true;
        }
        Graphics2D g = (Graphics2D)graphics2D.create();
        BufferedImage cachedVisibleImage = drawNewImg ? null : previousVisibleImage;
        double currentScale = this.myScreenView.getScale();
        if ((drawNewImg || currentScale != this.myLastScale || !this.myScreenViewVisibleRect.equals(this.myCachedScreenViewDisplayRect)) && this.myLastRenderResult != null && (renderedImage = this.myLastRenderResult.getRenderedImage().getCopy()) != null) {
            int resultImageWidth = renderedImage.getWidth();
            int resultImageHeight = renderedImage.getHeight();
            this.myCachedScreenViewDisplayRect.setBounds(this.myScreenViewVisibleRect);
            double xScaleFactor = (double)resultImageWidth / (double)this.myScreenViewSize.width;
            double yScaleFactor = (double)resultImageHeight / (double)this.myScreenViewSize.height;
            this.cancelHighQualityScaleRequests();
            if (xScaleFactor > 1.2 && yScaleFactor > 1.2 && !this.myScreenView.isAnimated()) {
                this.requestHighQualityScaledImage(ScaleContext.create((Graphics2D)g));
            }
            this.myCachedVisibleImage = cachedVisibleImage = ScreenViewLayer.getPreviewImage(g.getDeviceConfiguration(), renderedImage, this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewVisibleRect, xScaleFactor, yScaleFactor, previousVisibleImage, this.myScreenView.hasBorderLayer());
            this.myLastScale = currentScale;
        }
        if (cachedVisibleImage != null) {
            Shape screenShape = this.myScreenView.getScreenShape();
            if (screenShape != null) {
                g.clip(screenShape);
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)cachedVisibleImage, (int)this.myScreenViewVisibleRect.x, (int)this.myScreenViewVisibleRect.y, null);
        }
        g.dispose();
    }

    protected void setLastRenderResult(@Nullable RenderResult result2) {
        this.myLastRenderResult = result2;
    }

    private boolean newRenderImageAvailable(@Nullable RenderResult renderResult) {
        return renderResult != null && renderResult.getRenderResult().isSuccess() && renderResult != this.myLastRenderResult;
    }

    private void cancelHighQualityScaleRequests() {
        if (this.myScheduledFuture != null && !this.myScheduledFuture.isDone()) {
            this.myScheduledFuture.cancel(true);
        }
    }

    private void requestHighQualityScaledImage(@NotNull ScaleContext ctx) {
        if (this.myLastRenderResult == null) {
            return;
        }
        ImagePool.Image image = this.myLastRenderResult.getRenderedImage();
        double xScaleFactor = (double)image.getWidth() / (double)this.myScreenViewSize.width;
        double yScaleFactor = (double)image.getHeight() / (double)this.myScreenViewSize.height;
        int sx = (int)Math.round((double)(this.myScreenViewVisibleRect.x - this.myScreenView.getX()) * xScaleFactor);
        int sy = (int)Math.round((double)(this.myScreenViewVisibleRect.y - this.myScreenView.getY()) * yScaleFactor);
        int sw = (int)Math.round((double)this.myScreenViewVisibleRect.width * xScaleFactor);
        int sh = (int)Math.round((double)this.myScreenViewVisibleRect.height * yScaleFactor);
        if (sx + sw > image.getWidth()) {
            sw = image.getWidth() - sx;
        }
        if (sy + sh > image.getHeight()) {
            sh = image.getHeight() - sy;
        }
        if (sw <= 0 || sh <= 0) {
            Logger.getInstance(ScreenViewLayer.class).warn(String.format("requestHighQualityScaledImage with invalid size (sw=%d, sh=%d)", sw, sh));
            return;
        }
        BufferedImage imageCopy = image.getCopy(sx, sy, sw, sh);
        if (imageCopy == null) {
            return;
        }
        this.myRescaleRunnable.setSource(imageCopy, xScaleFactor, yScaleFactor, ctx);
        try {
            this.myScheduledFuture = this.myScheduledExecutorService.schedule(this.myRescaleRunnable, 300L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            Logger.getInstance(ScreenViewLayer.class).warn((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setLastRenderResult(null);
        this.myScheduledExecutorService.shutdown();
    }

    @Nullable
    private static BufferedImage getRetinaScaledImage(@NotNull BufferedImage original, double scaleX, double scaleY, @NotNull ScaleContext ctx, boolean fastScaling) {
        double xRetinaScale = JBUIScale.sysScale((ScaleContext)ctx) * scaleX;
        double yRetinaScale = JBUIScale.sysScale((ScaleContext)ctx) * scaleY;
        original = fastScaling ? ImageUtils.lowQualityFastScale((BufferedImage)original, (double)xRetinaScale, (double)yRetinaScale) : ImageUtils.scale((BufferedImage)original, (double)xRetinaScale, (double)yRetinaScale);
        return ImageUtils.convertToRetina((BufferedImage)original, (ScaleContext)ctx);
    }

    @VisibleForTesting
    @NotNull
    static BufferedImage scaleOriginalImage(@NotNull BufferedImage source, double xScaleFactor, double yScaleFactor, @NotNull ScaleContext ctx) {
        BufferedImage scaledImage = null;
        if (StartupUiUtil.isJreHiDPI((ScaleContext)ctx) && ImageUtils.supportsRetina()) {
            scaledImage = ScreenViewLayer.getRetinaScaledImage(source, 1.0 / xScaleFactor, 1.0 / yScaleFactor, ctx, false);
        }
        if (scaledImage == null) {
            scaledImage = ImageUtils.scale((BufferedImage)source, (double)(1.0 / xScaleFactor), (double)(1.0 / yScaleFactor));
        }
        return scaledImage;
    }

    private void onScaledResultReady(BufferedImage result2) {
        this.myCachedVisibleImage = result2;
        UIUtil.invokeLaterIfNeeded(() -> this.myScreenView.getSurface().repaint());
    }

    private static class RescaleRunnable
    implements Runnable {
        @NotNull
        private final Consumer<BufferedImage> myOnReadyCallback;
        private final Object lock = new Object();
        private BufferedImage mySourceImage;
        private double myXScaleFactor;
        private double myYScaleFactor;
        private ScaleContext myScaleContext;

        private RescaleRunnable(@NotNull Consumer<BufferedImage> onReadyCallback) {
            this.myOnReadyCallback = onReadyCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSource(@NotNull BufferedImage sourceImage, double xScaleFactor, double yScaleFactor, @NotNull ScaleContext ctx) {
            Object object = this.lock;
            synchronized (object) {
                this.mySourceImage = sourceImage;
                this.myXScaleFactor = xScaleFactor;
                this.myYScaleFactor = yScaleFactor;
                this.myScaleContext = ctx;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ScaleContext ctx;
            double yScaleFactor;
            double xScaleFactor;
            BufferedImage source;
            Object object = this.lock;
            synchronized (object) {
                source = this.mySourceImage;
                xScaleFactor = this.myXScaleFactor;
                yScaleFactor = this.myYScaleFactor;
                ctx = this.myScaleContext;
                this.mySourceImage = null;
            }
            if (source == null) {
                return;
            }
            BufferedImage result2 = ScreenViewLayer.scaleOriginalImage(source, xScaleFactor, yScaleFactor, ctx);
            this.myOnReadyCallback.accept(result2);
        }
    }
}

