/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.AndroidColorSet;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.BorderLayer;
import com.android.tools.idea.uibuilder.surface.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.DiagnosticsLayer;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.OverlayLayer;
import com.android.tools.idea.uibuilder.surface.ScreenViewBase;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.type.LayoutEditorFileType;
import com.google.common.collect.ImmutableList;
import java.awt.Dimension;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenView
extends ScreenViewBase {
    public static final ContentSizePolicy DEVICE_CONTENT_SIZE_POLICY = new ContentSizePolicy(){

        @Override
        public void measure(@NotNull ScreenView screenView, @NotNull Dimension outDimension) {
            Configuration configuration = screenView.getConfiguration();
            Device device = configuration.getCachedDevice();
            State state = configuration.getDeviceState();
            if (device != null && state != null) {
                HardwareConfig config = new HardwareConfigHelper(device).setOrientation(state.getOrientation()).getConfig();
                outDimension.setSize(config.getScreenWidth(), config.getScreenHeight());
            }
        }
    };
    private static final Function<ScreenView, ImmutableList<Layer>> DEFAULT_LAYERS_PROVIDER = screenView -> {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        if (screenView.hasBorderLayer()) {
            builder2.add((Object)new BorderLayer((ScreenViewBase)screenView));
        }
        builder2.add((Object)new ScreenViewLayer((ScreenView)screenView));
        NlDesignSurface surface2 = screenView.getSurface();
        SceneLayer sceneLayer = new SceneLayer(surface2, (SceneView)screenView, false);
        sceneLayer.setAlwaysShowSelection(true);
        builder2.add((Object)sceneLayer);
        if (((Boolean)StudioFlags.NELE_OVERLAY_PROVIDER.get()).booleanValue()) {
            builder2.add((Object)new OverlayLayer((SceneView)screenView));
        }
        if (screenView.myIsResizeable && screenView.getSceneManager().getModel().getType().isEditable()) {
            builder2.add((Object)new CanvasResizeLayer(surface2, (ScreenView)screenView));
        }
        if (((Boolean)StudioFlags.NELE_RENDER_DIAGNOSTICS.get()).booleanValue()) {
            builder2.add((Object)new DiagnosticsLayer(surface2));
        }
        return builder2.build();
    };
    private final boolean myHasBorderLayer;
    private final boolean myIsResizeable;
    @NotNull
    private final ColorSet myColorSet;
    @NotNull
    private final Function<ScreenView, ImmutableList<Layer>> myLayersProvider;
    @NotNull
    private final ContentSizePolicy myContentSizePolicy;

    @NotNull
    public static Builder newBuilder(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager) {
        return new Builder(surface2, manager);
    }

    private ScreenView(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager, @NotNull SceneView.ShapePolicy shapePolicy, boolean isResizeable, boolean hasBorderLayer, @NotNull ColorSet colorSet, @NotNull Function<ScreenView, ImmutableList<Layer>> layersProvider, @NotNull ContentSizePolicy contentSizePolicy) {
        super(surface2, manager, shapePolicy);
        this.myHasBorderLayer = hasBorderLayer;
        this.myIsResizeable = isResizeable;
        this.myColorSet = colorSet;
        this.myLayersProvider = layersProvider;
        this.myContentSizePolicy = contentSizePolicy;
    }

    public ScreenView(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager, @NotNull ContentSizePolicy contentSizePolicy) {
        this(surface2, manager, SQUARE_SHAPE_POLICY, true, false, new AndroidColorSet(), DEFAULT_LAYERS_PROVIDER, contentSizePolicy);
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension2) {
        if (dimension2 == null) {
            dimension2 = new Dimension();
        }
        this.myContentSizePolicy.measure(this, dimension2);
        return dimension2;
    }

    @Override
    @NotNull
    protected ImmutableList<Layer> createLayers() {
        return this.myLayersProvider.apply(this);
    }

    public boolean hasBorderLayer() {
        return this.myHasBorderLayer;
    }

    private static boolean isErrorResult(@NotNull RenderResult result2) {
        ImagePool.Image image = result2.getRenderedImage();
        return result2.getLogger().hasErrors() && (!image.isValid() || image.getWidth() * image.getHeight() < 2);
    }

    @Override
    public boolean hasContent() {
        RenderResult result2 = this.getSceneManager().getRenderResult();
        return result2 != null && !ScreenView.isErrorResult(result2);
    }

    @Override
    @NotNull
    public ColorSet getColorSet() {
        return this.myColorSet;
    }

    @Override
    public boolean isResizeable() {
        return this.myIsResizeable;
    }

    static /* synthetic */ Function access$000() {
        return DEFAULT_LAYERS_PROVIDER;
    }

    public static class Builder {
        @NotNull
        final NlDesignSurface mySurface;
        @NotNull
        final LayoutlibSceneManager myManager;
        boolean isResizeable = false;
        boolean hasBorderLayer;
        @Nullable
        ColorSet myColorSet = null;
        @NotNull
        Function<ScreenView, ImmutableList<Layer>> myLayersProvider = ScreenView.access$000();
        @NotNull
        private ContentSizePolicy myContentSizePolicy = DEVICE_CONTENT_SIZE_POLICY;
        @NotNull
        private SceneView.ShapePolicy myShapePolicy = SceneView.DEVICE_CONFIGURATION_SHAPE_POLICY;

        private Builder(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager) {
            this.mySurface = surface2;
            this.myManager = manager;
            this.hasBorderLayer = manager.getModel().getType() instanceof LayoutEditorFileType;
        }

        @NotNull
        public Builder resizeable() {
            this.isResizeable = true;
            return this;
        }

        @NotNull
        public Builder withColorSet(@NotNull ColorSet colorSet) {
            this.myColorSet = colorSet;
            return this;
        }

        @NotNull
        public Builder withLayersProvider(@NotNull Function<ScreenView, ImmutableList<Layer>> layersProvider) {
            this.myLayersProvider = layersProvider;
            return this;
        }

        @NotNull
        public Builder withContentSizePolicy(@NotNull ContentSizePolicy contentSizePolicy) {
            this.myContentSizePolicy = contentSizePolicy;
            return this;
        }

        @NotNull
        public Builder withShapePolicy(@NotNull SceneView.ShapePolicy shapePolicy) {
            this.myShapePolicy = shapePolicy;
            return this;
        }

        @NotNull
        public Builder decorateContentSizePolicy(@NotNull Function<ContentSizePolicy, ContentSizePolicy> contentSizePolicyProvider) {
            this.myContentSizePolicy = contentSizePolicyProvider.apply(this.myContentSizePolicy);
            return this;
        }

        @NotNull
        public Builder disableBorder() {
            this.hasBorderLayer = false;
            return this;
        }

        @NotNull
        public ScreenView build() {
            return new ScreenView(this.mySurface, this.myManager, this.myShapePolicy, this.isResizeable, this.hasBorderLayer, this.myColorSet == null ? new AndroidColorSet() : this.myColorSet, this.myLayersProvider, this.myContentSizePolicy);
        }
    }

    public static final class ImageContentSizePolicy
    implements ContentSizePolicy {
        @NotNull
        private final ContentSizePolicy mySizePolicyDelegate;
        private Dimension cachedDimension = null;

        public ImageContentSizePolicy(@NotNull ContentSizePolicy delegate2) {
            this.mySizePolicyDelegate = delegate2;
        }

        @Override
        public void measure(@NotNull ScreenView screenView, @NotNull Dimension outDimension) {
            RenderResult result2 = screenView.getSceneManager().getRenderResult();
            if (result2 != null && result2.getSystemRootViews().size() == 1) {
                ViewInfo viewInfo = (ViewInfo)result2.getSystemRootViews().get(0);
                try {
                    outDimension.setSize(viewInfo.getRight(), viewInfo.getBottom());
                    if (this.cachedDimension == null) {
                        this.cachedDimension = new Dimension(outDimension);
                    } else {
                        this.cachedDimension.setSize(outDimension);
                    }
                    return;
                }
                catch (AssertionError assertionError) {
                    // empty catch block
                }
            }
            if (this.cachedDimension != null) {
                outDimension.setSize(this.cachedDimension);
                return;
            }
            this.mySizePolicyDelegate.measure(screenView, outDimension);
        }
    }

    public static interface ContentSizePolicy {
        public void measure(@NotNull ScreenView var1, @NotNull Dimension var2);
    }
}

