/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.ItemTransferable;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import org.jetbrains.annotations.NotNull;

public class NlDropEvent {
    private final DropTargetDragEvent myDragEvent;
    private final DropTargetDropEvent myDropEvent;
    private boolean myStatusSpecified;

    public NlDropEvent(@NotNull DropTargetDragEvent dragEvent) {
        this.myDragEvent = dragEvent;
        this.myDropEvent = null;
    }

    public NlDropEvent(@NotNull DropTargetDropEvent dropEvent) {
        this.myDragEvent = null;
        this.myDropEvent = dropEvent;
    }

    @NotNull
    public Point getLocation() {
        if (this.myDragEvent != null) {
            return this.myDragEvent.getLocation();
        }
        return this.myDropEvent.getLocation();
    }

    public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
        if (this.myDragEvent != null) {
            return this.myDragEvent.isDataFlavorSupported(flavor);
        }
        return this.myDropEvent.isDataFlavorSupported(flavor);
    }

    public int getDropAction() {
        if (this.myDragEvent != null) {
            return this.myDragEvent.getDropAction();
        }
        return this.myDropEvent.getDropAction();
    }

    @NotNull
    public Transferable getTransferable() {
        if (!this.myStatusSpecified && !this.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR) && this.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.accept(1);
        }
        if (this.myDragEvent != null) {
            return this.myDragEvent.getTransferable();
        }
        return this.myDropEvent.getTransferable();
    }

    public void accept(@NotNull InsertType insertType) {
        this.accept(insertType == InsertType.COPY ? this.getDropAction() : 1);
    }

    private void accept(int dropAction) {
        if (!this.myStatusSpecified) {
            if (this.myDragEvent != null) {
                this.myDragEvent.acceptDrag(dropAction);
            } else {
                this.myDropEvent.acceptDrop(dropAction);
            }
            this.myStatusSpecified = true;
        }
    }

    public void reject() {
        if (!this.myStatusSpecified) {
            if (this.myDragEvent != null) {
                this.myDragEvent.rejectDrag();
            } else {
                this.myDropEvent.rejectDrop();
            }
            this.myStatusSpecified = true;
        }
    }

    public void complete() {
        if (this.myDropEvent != null) {
            this.myDropEvent.dropComplete(true);
        }
    }
}

