/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.backgroundremove;

import com.android.tools.idea.ui.resourcechooser.util.CheckerboardPaint;
import com.android.tools.idea.uibuilder.mockup.backgroundremove.HistoryManager;
import com.android.tools.idea.uibuilder.mockup.backgroundremove.RemoveColorComposite;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveBackgroundPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final int MAX_DRAG_DIST = 300;
    public static final CheckerboardPaint CHECKERBOARD_PAINT = new CheckerboardPaint(10);
    private final HistoryManager<BufferedImage> myImageHistoryManager;
    AffineTransform myAffineTransform;
    @Nullable
    private BufferedImage myImage;
    private BufferedImage myNewImage;
    private Point myPointHolder = new Point();
    private Point myMouseOrigin = new Point();
    private Point myCurrentMouse = new Point();
    private RemoveColorComposite myExtractComposite;
    private boolean myIsExtracting;

    public RemoveBackgroundPanel() {
        this.myAffineTransform = new AffineTransform();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(false);
        this.myExtractComposite = new RemoveColorComposite();
        this.setBackground(UIUtil.getPanelBackground());
        this.myImageHistoryManager = new HistoryManager();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myImage == null) {
            return;
        }
        this.updateTransform();
        Graphics2D g2d = (Graphics2D)g;
        Paint paint = g2d.getPaint();
        g2d.setPaint(CHECKERBOARD_PAINT);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setPaint(paint);
        if (this.myIsExtracting) {
            g2d.drawImage(this.myNewImage, this.myAffineTransform, null);
            double dragDist = this.myMouseOrigin.distance(this.myCurrentMouse);
            if (dragDist > 0.0) {
                g2d.drawLine(this.myMouseOrigin.x, this.myMouseOrigin.y, this.myCurrentMouse.x, this.myCurrentMouse.y);
                g2d.drawString(String.valueOf(Math.round(dragDist / 300.0 * 100.0)), this.myMouseOrigin.x, this.myMouseOrigin.y);
            }
        } else {
            g2d.drawImage(this.myImage, this.myAffineTransform, null);
        }
    }

    public void setImage(@Nullable BufferedImage image) {
        if (image == null) {
            this.myImage = null;
            return;
        }
        this.myImage = RemoveBackgroundPanel.createNewImage(image);
        this.myImageHistoryManager.setOriginalImage(this.myImage);
        this.myNewImage = RemoveBackgroundPanel.createNewImage(image);
        this.repaintImage();
        this.updateTransform();
    }

    private void updateTransform() {
        if (this.myImage == null) {
            return;
        }
        double scale = Math.min((double)this.getWidth() / (double)this.myImage.getWidth(), (double)this.getHeight() / (double)this.myImage.getHeight());
        this.myAffineTransform.setToIdentity();
        this.myAffineTransform.translate(((double)this.getWidth() - scale * (double)this.myImage.getWidth()) / 2.0, ((double)this.getHeight() - scale * (double)this.myImage.getHeight()) / 2.0);
        this.myAffineTransform.scale(scale, scale);
    }

    private void repaintImage() {
        if (this.myImage == null) {
            return;
        }
        Graphics2D g2d = this.myNewImage.createGraphics();
        g2d.setComposite(this.myExtractComposite);
        g2d.drawImage(this.myImage, 0, 0, this.myImage.getWidth(), this.myImage.getHeight(), null);
        g2d.dispose();
        this.repaint();
    }

    @NotNull
    private static BufferedImage createNewImage(@NotNull BufferedImage image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        return newImage;
    }

    public boolean canUndo() {
        return this.myImageHistoryManager.canUndo();
    }

    public boolean canRedo() {
        return this.myImageHistoryManager.canRedo();
    }

    public void undo() {
        if (this.myImageHistoryManager.canUndo()) {
            this.myNewImage = this.myImage;
            this.myImage = this.myImageHistoryManager.undo();
            this.repaintImage();
            this.repaint();
        }
    }

    public void redo() {
        this.myImage = this.myImageHistoryManager.redo();
        this.repaintImage();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.myIsExtracting) {
            return;
        }
        this.myCurrentMouse.setLocation(e.getPoint());
        this.myExtractComposite.setThreshold(e.getPoint().distance(this.myMouseOrigin) / 300.0);
        this.repaintImage();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.myImage == null) {
            return;
        }
        this.updateTransform();
        this.myMouseOrigin.setLocation(e.getPoint());
        this.myCurrentMouse.setLocation(e.getPoint());
        try {
            this.myAffineTransform.inverseTransform(e.getPoint(), this.myPointHolder);
            int width = this.myImage.getWidth();
            if (this.myPointHolder.x < 0 || this.myPointHolder.y < 0 || this.myPointHolder.x >= width || this.myPointHolder.y >= this.myImage.getHeight()) {
                return;
            }
            int removeColor = this.myImage.getRGB(this.myPointHolder.x, this.myPointHolder.y);
            int[] pixel = new int[4];
            this.myImage.getRaster().getPixel(this.myPointHolder.x, this.myPointHolder.y, pixel);
            if (pixel[3] == 0) {
                return;
            }
            this.myIsExtracting = true;
            this.myExtractComposite.setRemoveColor(removeColor);
            this.myExtractComposite.setOriginPixel(this.myPointHolder.x, this.myPointHolder.y);
            this.myExtractComposite.setThreshold(0.0);
            this.myExtractComposite.setAreaOnly((e.getModifiersEx() & 0x40) != 64);
            this.myNewImage = RemoveBackgroundPanel.createNewImage(this.myImage);
            this.repaintImage();
        }
        catch (NoninvertibleTransformException e1) {
            Logger.getInstance(RemoveBackgroundPanel.class).warn("Could not invert transform");
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.myMouseOrigin.setLocation(0, 0);
        this.myCurrentMouse.setLocation(0, 0);
        if (this.myImage == null || !this.myIsExtracting) {
            return;
        }
        this.myIsExtracting = false;
        this.myImage = this.myNewImage;
        this.myImageHistoryManager.pushUndo(this.myImage);
        this.repaintImage();
    }

    @Nullable
    public BufferedImage getImage() {
        return this.myImage;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

