/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.backgroundremove;

import com.android.tools.idea.uibuilder.mockup.backgroundremove.RemoveColorComposite;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;

public final class RemoveAlgorithms {
    static final int R = 0;
    static final int G = 1;
    static final int B = 2;

    static void floodFill(Raster src, Raster dstIn, WritableRaster dstOut, int ox, int oy, int[] removeColor, double threshold) {
        int height = Math.min(src.getHeight(), dstIn.getHeight());
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int[] dstPixels = new int[width];
        int[] srcDownPixels = new int[width];
        int[] srcUpPixels = new int[width];
        int[] srcPixels = new int[width];
        int[] stack = new int[width * height];
        boolean[] visited = new boolean[width * height];
        int size = 0;
        if (oy > height || ox > width) {
            Logger.getInstance(RemoveColorComposite.class).error((Throwable)new RasterFormatException("The origin point is outside the raster area"));
        }
        stack[size++] = oy * width + ox % width;
        dstOut.setDataElements(0, 0, src);
        while (size > 0) {
            int nx;
            int seed = stack[--size];
            int y = seed / width;
            int x = seed % width;
            dstIn.getDataElements(0, y, width, 1, dstPixels);
            src.getDataElements(0, y, width, 1, srcPixels);
            if (y > 0) {
                src.getDataElements(0, y - 1, width, 1, srcUpPixels);
            }
            if (y < height - 1) {
                src.getDataElements(0, y + 1, width, 1, srcDownPixels);
            }
            for (nx = x; nx >= 0 && RemoveAlgorithms.dist(srcPixels[nx], removeColor) <= threshold; --nx) {
            }
            ++nx;
            boolean spanDown = false;
            boolean spanUp = false;
            while (nx < width) {
                double d;
                double dist = RemoveAlgorithms.dist(srcPixels[nx], removeColor);
                if (!(d <= threshold)) break;
                if (visited[y * width + nx % width]) {
                    ++nx;
                    continue;
                }
                visited[y * width + nx % width] = true;
                double alpha = (dstPixels[nx] >> 24 & 0xFF) == 255 && dist > threshold / 2.0 ? 255.0 * (dist / threshold) : 0.0;
                dstPixels[nx] = srcPixels[nx] & 0xFFFFFF | Math.round((float)alpha) << 24;
                double distUp = RemoveAlgorithms.dist(srcUpPixels[nx], removeColor);
                if (!spanUp && y > 0 && distUp <= threshold) {
                    stack[size++] = (y - 1) * width + nx % width;
                    spanUp = true;
                } else if (spanUp && y > 0 && distUp > threshold) {
                    spanUp = false;
                }
                double distDown = RemoveAlgorithms.dist(srcDownPixels[nx], removeColor);
                if (!spanDown && y < height - 1 && distDown <= threshold) {
                    stack[size++] = (y + 1) * width + nx % width;
                    spanDown = true;
                } else if (spanDown && y < height - 1 && distDown > threshold) {
                    spanDown = false;
                }
                ++nx;
            }
            dstOut.setDataElements(0, y, width, 1, dstPixels);
        }
    }

    static void whole(Raster src, Raster dstIn, WritableRaster dstOut, int[] removeColor, double threshold) {
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int[] dstPixels = new int[width];
        int[] srcPixels = new int[width];
        for (int y = 0; y < Math.min(src.getHeight(), dstIn.getHeight()); ++y) {
            dstIn.getDataElements(0, y, width, 1, dstPixels);
            src.getDataElements(0, y, width, 1, srcPixels);
            for (int x = 0; x < width; ++x) {
                int pixel = srcPixels[x];
                double dist = RemoveAlgorithms.dist(pixel, removeColor);
                int alpha = dist <= threshold ? (dist > threshold / 2.0 ? (int)Math.round(255.0 * (dist / threshold)) : 0) : 255;
                dstPixels[x] = pixel & 0xFFFFFF | (alpha & 0xFF) << 24;
            }
            dstOut.setDataElements(0, y, width, 1, dstPixels);
        }
    }

    private static double dist(int colorA, int[] colorB) {
        return Math.abs(colorB[0] - (colorA >> 16 & 0xFF)) + Math.abs(colorB[1] - (colorA >> 8 & 0xFF)) + Math.abs(colorB[2] - (colorA & 0xFF));
    }
}

